/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.Command;
import org.wetator.core.IScripter;
import org.wetator.core.Parameter;
import org.wetator.exception.InvalidInputException;

public final class LegacyXMLScripter
implements IScripter {
    private static final String WET_FILE_EXTENSION = ".wet";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String BASE_SCHEMA = "http://www.wetator.org/xsd/defaultCommandSet";
    private static final String E_TESTCASE = "testcase";
    public static final String E_STEP = "step";
    public static final String E_OPTIONAL_PARAMETER = "optionalParameter";
    public static final String E_OPTIONAL_PARAMETER2 = "optionalParameter2";
    public static final String A_COMMAND = "command";
    public static final String A_COMMENT = "comment";
    private File file;
    private List<Command> commands;

    @Override
    public void initialize(Properties aConfiguration) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IScripter.IsSupportedResult isSupported(File aFile) {
        String tmpFileName = aFile.getName().toLowerCase(Locale.ROOT);
        if (!tmpFileName.endsWith(WET_FILE_EXTENSION) && !tmpFileName.endsWith(XML_FILE_EXTENSION)) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Extension is not '" + WET_FILE_EXTENSION + "' or '" + XML_FILE_EXTENSION + "'.");
        }
        if (!aFile.exists()) return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not find file.");
        if (!aFile.isFile()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not find file.");
        }
        if (!aFile.canRead()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not read file.");
        }
        try (LineIterator tmpLines = FileUtils.lineIterator((File)aFile.getAbsoluteFile(), (String)"UTF-8");){
            String tmpLine;
            boolean tmpTestCase = false;
            do {
                if (!tmpLines.hasNext()) return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not parse file.");
                tmpLine = tmpLines.next().trim();
                if (tmpLine.contains("<testcase")) {
                    tmpTestCase = true;
                }
                if (!tmpLine.contains("step ")) continue;
                return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not parse file.");
            } while (!tmpTestCase || !tmpLine.contains(BASE_SCHEMA));
            IScripter.IsSupportedResult isSupportedResult = IScripter.IS_SUPPORTED;
            return isSupportedResult;
        }
        catch (FileNotFoundException e) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not find file (" + e.getMessage() + ").");
        }
        catch (IOException e) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by LegacyXMLScripter. Could not read file (" + e.getMessage() + ").");
        }
    }

    @Override
    public void script(File aFile) throws InvalidInputException {
        this.file = aFile;
        this.commands = this.readCommands();
    }

    private List<Command> readCommands() throws InvalidInputException {
        InputStream tmpInputStream;
        try {
            tmpInputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InvalidInputException("Could not find file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "'.", e);
        }
        XMLStreamReader tmpReader = null;
        try {
            XMLInputFactory tmpFactory = XMLInputFactory.newInstance();
            try {
                tmpReader = tmpFactory.createXMLStreamReader(tmpInputStream);
            }
            catch (XMLStreamException e) {
                throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "' (" + e.getMessage() + ").", e);
            }
            try {
                ArrayList<Command> tmpResult = new ArrayList<Command>();
                Command tmpCommand = null;
                while (tmpReader.hasNext()) {
                    if (tmpReader.next() == 1) {
                        String tmpOptionalParameter;
                        if (E_STEP.equals(tmpReader.getLocalName())) {
                            String tmpIsCommentAsString;
                            String tmpCommandName = tmpReader.getAttributeValue(null, A_COMMAND);
                            boolean tmpIsComment = A_COMMENT.equals((tmpCommandName = tmpCommandName.replace(' ', '-').replace('_', '-').toLowerCase(Locale.ROOT)).toLowerCase(Locale.ROOT));
                            if (!tmpIsComment && StringUtils.isNotEmpty((CharSequence)(tmpIsCommentAsString = tmpReader.getAttributeValue(null, A_COMMENT)))) {
                                tmpIsComment = Boolean.parseBoolean(tmpIsCommentAsString);
                            }
                            tmpCommand = new Command(tmpCommandName, tmpIsComment);
                            tmpCommand.setLineNo(tmpResult.size() + 1);
                            StringBuilder tmpParameters = new StringBuilder("");
                            while (tmpReader.next() == 4) {
                                tmpParameters.append(tmpReader.getText());
                            }
                            String tmpParameterValue = tmpParameters.toString();
                            if (StringUtils.isNotEmpty((CharSequence)tmpParameterValue)) {
                                tmpCommand.setFirstParameter(new Parameter(tmpParameterValue));
                            }
                        }
                        if (E_OPTIONAL_PARAMETER.equals(tmpReader.getLocalName())) {
                            tmpOptionalParameter = tmpReader.getElementText();
                            if (null == tmpCommand) {
                                throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "'. Unexpected optional parameter '" + tmpOptionalParameter + "'.");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)tmpOptionalParameter)) {
                                tmpCommand.setSecondParameter(new Parameter(tmpOptionalParameter));
                            }
                            tmpReader.next();
                        }
                        if (E_OPTIONAL_PARAMETER2.equals(tmpReader.getLocalName())) {
                            tmpOptionalParameter = tmpReader.getElementText();
                            if (null == tmpCommand) {
                                throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "'. Unexpected optional parameter 2 '" + tmpOptionalParameter + "'.");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)tmpOptionalParameter)) {
                                tmpCommand.setThirdParameter(new Parameter(tmpOptionalParameter));
                            }
                            tmpReader.next();
                        }
                    }
                    if (tmpReader.getEventType() != 2 || !E_STEP.equals(tmpReader.getLocalName())) continue;
                    tmpResult.add(tmpCommand);
                }
                ArrayList<Command> arrayList = tmpResult;
                return arrayList;
            }
            catch (XMLStreamException e) {
                throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "' (" + e.getMessage() + ").", e);
            }
        }
        finally {
            if (tmpReader != null) {
                try {
                    tmpReader.close();
                }
                catch (Exception exception) {}
            }
            if (tmpInputStream != null) {
                try {
                    tmpInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }
}

