/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.progresslistener;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XSLTransformer {
    private static final Logger LOG = LogManager.getLogger(XSLTransformer.class);
    private static final String RESOURCES_DIRECTORY = "resources";
    private File xmlResultFile;

    public XSLTransformer(File aXMLResultFile) {
        this.xmlResultFile = aXMLResultFile;
    }

    public void transform(Iterable<String> aListOfXslFileNames, File anOutputDirectory) {
        for (String tmpXslFileName : aListOfXslFileNames) {
            final File tmpXslFile = new File(tmpXslFileName);
            File tmpResultFile = new File(anOutputDirectory, tmpXslFile.getName() + ".html");
            try {
                StreamSource tmpXlsStreamSource = new StreamSource(tmpXslFile);
                TransformerFactory tmpTransformerFactory = TransformerFactory.newInstance();
                tmpTransformerFactory.setErrorListener(new ErrorListener(){

                    @Override
                    public void warning(TransformerException anException) throws TransformerException {
                        LOG.warn("Problem parsing XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "' (" + anException.getMessage() + ").");
                    }

                    @Override
                    public void fatalError(TransformerException anException) throws TransformerException {
                        LOG.error("Parsing XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "' failed (" + anException.getMessage() + ").");
                    }

                    @Override
                    public void error(TransformerException anException) throws TransformerException {
                        LOG.error("Problem parsing XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "' failed (" + anException.getMessage() + ").");
                    }
                });
                Transformer tmpTransformer = tmpTransformerFactory.newTransformer(tmpXlsStreamSource);
                if (null == tmpTransformer) {
                    LOG.error("Problem parsing XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "'. Aborting.");
                    return;
                }
                StreamSource tmpXmlStreamSource = new StreamSource(this.xmlResultFile);
                OutputStream tmpFileOutputStream = Files.newOutputStream(tmpResultFile.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedOutputStream tmpBufferedOutputStream = new BufferedOutputStream(tmpFileOutputStream);
                    Throwable throwable2 = null;
                    try {
                        StreamResult tmpStreamResult = new StreamResult(tmpBufferedOutputStream);
                        tmpTransformer.transform(tmpXmlStreamSource, tmpStreamResult);
                        this.copyImages(tmpXslFile.getParentFile(), anOutputDirectory);
                        LOG.info("Report written to " + FilenameUtils.normalize((String)tmpResultFile.getAbsolutePath()));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (tmpBufferedOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                tmpBufferedOutputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        tmpBufferedOutputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (tmpFileOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            tmpFileOutputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    tmpFileOutputStream.close();
                }
            }
            catch (TransformerConfigurationException e) {
                LOG.error("Problem loading XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "'. Aborting.", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Problem writing Report '" + FilenameUtils.normalize((String)tmpResultFile.getAbsolutePath()) + "'. Aborting.", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Problem applying XSL-Template '" + FilenameUtils.normalize((String)tmpXslFile.getAbsolutePath()) + "'. Aborting.", (Throwable)e);
            }
        }
    }

    public void copyImages(File aSourceDir, File aTargetDir) throws IOException {
        File tmpSourceDir = new File(aSourceDir, RESOURCES_DIRECTORY);
        File tmpTargetDir = new File(aTargetDir, RESOURCES_DIRECTORY);
        this.copyFiles(tmpSourceDir, tmpTargetDir);
    }

    private void copyFiles(File aSourceDir, File aTargetDir) throws IOException {
        if (aTargetDir.exists()) {
            return;
        }
        if (!aTargetDir.mkdirs()) {
            LOG.error("Can't create '" + FilenameUtils.normalize((String)aTargetDir.getAbsolutePath()) + "'.");
            return;
        }
        File[] tmpImageFiles = aSourceDir.listFiles();
        if (null == tmpImageFiles) {
            return;
        }
        for (File tmpSourceFile : tmpImageFiles) {
            String tmpSourceFileName = tmpSourceFile.getName();
            if (null != tmpSourceFileName && tmpSourceFileName.startsWith(".")) continue;
            if (tmpSourceFile.isDirectory()) {
                File tmpTargetSubDir = new File(aTargetDir, tmpSourceFile.getName());
                this.copyFiles(tmpSourceFile, tmpTargetSubDir);
                continue;
            }
            File tmpTargetFile = new File(aTargetDir, tmpSourceFile.getName());
            try (InputStream tmpIn = Files.newInputStream(tmpSourceFile.toPath(), new OpenOption[0]);
                 OutputStream tmpOut = Files.newOutputStream(tmpTargetFile.toPath(), new OpenOption[0]);){
                int tmpBytes;
                byte[] tmpBuffer = new byte[1024];
                while ((tmpBytes = tmpIn.read(tmpBuffer)) > -1) {
                    tmpOut.write(tmpBuffer, 0, tmpBytes);
                }
            }
            catch (IOException e) {
                LOG.error("Can't copy '" + FilenameUtils.normalize((String)tmpSourceFile.getAbsolutePath()) + "'. File ignored.", (Throwable)e);
            }
        }
    }
}

