/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.progresslistener;

import dk.brics.automaton.Automaton;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.Version;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.core.Command;
import org.wetator.core.ICommandSet;
import org.wetator.core.IProgressListener;
import org.wetator.core.IScripter;
import org.wetator.core.Parameter;
import org.wetator.core.TestCase;
import org.wetator.core.Variable;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorContext;
import org.wetator.core.WetatorEngine;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.AssertionException;
import org.wetator.i18n.Messages;
import org.wetator.progresslistener.XSLTransformer;
import org.wetator.util.Output;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;
import org.wetator.util.VersionUtil;
import org.wetator.util.XMLUtil;

public class XMLResultWriter
implements IProgressListener {
    private static final Logger LOG = LogManager.getLogger(XMLResultWriter.class);
    private static final String TAG_WET = "wet";
    private static final String TAG_ABOUT = "about";
    private static final String TAG_LIBS = "libraries";
    private static final String TAG_LIB = "library";
    private static final String TAG_JAVA = "java";
    private static final String TAG_PRODUCT = "product";
    private static final String TAG_VERSION = "version";
    private static final String TAG_BUILD = "build";
    private static final String TAG_START_TIME = "startTime";
    private static final String TAG_TEST_FILE = "testFile";
    private static final String TAG_EXECUTION_TIME = "executionTime";
    private static final String TAG_TESTCASE = "testcase";
    private static final String TAG_TESTRUN = "testrun";
    private static final String TAG_TESTFILE = "testfile";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_FIRST_PARAM = "param0";
    private static final String TAG_SECOND_PARAM = "param1";
    private static final String TAG_THIRD_PARAM = "param2";
    private static final String TAG_DESCRIBE = "describe";
    private static final String TAG_RESPONSE = "response";
    private static final String TAG_HIGHLIGHT = "highlight";
    private static final String TAG_LOG = "log";
    private static final String TAG_LEVEL = "level";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_FAILURE = "failure";
    private static final String TAG_ERROR = "error";
    private static final String TAG_ERROR_DETAILS = "details";
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String TAG_VARIABLES = "variables";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_COMMAND_SET = "commandSet";
    private static final String TAG_CONTROL = "control";
    private static final String TAG_MIME_TYPE = "mimetype";
    private static final String TAG_IGNORED = "ignored";
    private Output output;
    private XMLUtil xmlUtil;
    private File resultFile;
    private File outputDir;
    private List<String> xslTemplates;
    private long tagId = 0L;
    private long executionStartTime;
    private Deque<Long> commandExecutionStartTimes = new ArrayDeque<Long>();

    @Override
    public void init(WetatorEngine aWetatorEngine) {
        try {
            String[] tmpJars;
            String[] tmpClassNames;
            WetatorConfiguration tmpConfiguration = aWetatorEngine.getConfiguration();
            this.outputDir = tmpConfiguration.getOutputDir();
            this.xslTemplates = tmpConfiguration.getXslTemplates();
            this.resultFile = new File(this.outputDir, "wetresult.xml");
            FileWriterWithEncoding tmpWriter = new FileWriterWithEncoding(this.resultFile, "UTF-8");
            this.output = new Output((Writer)tmpWriter, "  ");
            this.xmlUtil = new XMLUtil();
            this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            this.output.println();
            this.printlnStartTag(TAG_WET);
            this.printlnStartTag(TAG_ABOUT);
            this.printlnNode(TAG_PRODUCT, Version.getProductName());
            this.printlnNode(TAG_VERSION, Version.getVersion());
            this.printlnNode(TAG_BUILD, Version.getBuild());
            this.printlnStartTag(TAG_LIBS);
            StringBuilder tmpInfo = new StringBuilder();
            for (String tmpClassName : tmpClassNames = new String[]{"com.gargoylesoftware.htmlunit.WebClient", "net.sourceforge.htmlunit.corejs.javascript.Function", "net.sourceforge.htmlunit.cyberneko.HTMLElements", "com.gargoylesoftware.css.parser.CSSOMParser"}) {
                tmpInfo.setLength(0);
                try {
                    Class<?> tmpClass = Class.forName(tmpClassName);
                    tmpInfo.append(VersionUtil.determineVersionFromJarFileName(tmpClass)).append(" (").append(VersionUtil.determineCreationDateFromJarFileName(tmpClass)).append(')');
                }
                catch (ClassNotFoundException e) {
                    tmpInfo.append("Class '").append(tmpClassName).append("' not found in classpath.");
                }
                this.printlnNode(TAG_LIB, tmpInfo.toString());
            }
            for (String tmpJar : tmpJars = new String[]{"commons-lang3-\\S+jar", "commons-text-\\S+jar", "commons-codec-\\S+jar", "commons-io-\\S+jar", "httpcore-\\S+jar", "httpclient-\\S+jar", "httpmime-\\S+jar", "log4j-api-\\S+jar", "log4j-core-\\S+jar"}) {
                tmpInfo.setLength(0);
                tmpInfo.append(VersionUtil.determineTitleFromJarManifest(tmpJar, null)).append(' ').append(VersionUtil.determineVersionFromJarManifest(tmpJar, null));
                this.printlnNode(TAG_LIB, tmpInfo.toString());
            }
            this.printlnNode(TAG_LIB, VersionUtil.determineVersionFromJarFileName(Automaton.class));
            tmpInfo = new StringBuilder(org.apache.poi.Version.getProduct()).append(' ').append(org.apache.poi.Version.getVersion());
            this.printlnNode(TAG_LIB, tmpInfo.toString());
            tmpInfo = new StringBuilder("Apache PDFBox ").append(org.apache.pdfbox.util.Version.getVersion());
            this.printlnNode(TAG_LIB, tmpInfo.toString());
            tmpInfo = new StringBuilder(VersionUtil.determineBundleNameFromJarManifest("fontbox\\S+jar", null)).append(' ').append(VersionUtil.determineBundleVersionFromJarManifest("fontbox\\S+jar", null));
            this.printlnNode(TAG_LIB, tmpInfo.toString());
            this.printlnNode(TAG_LIB, org.apache.xmlcommons.Version.getVersion());
            this.printlnNode(TAG_LIB, org.apache.xerces.impl.Version.getVersion());
            this.printlnNode(TAG_LIB, org.apache.xalan.Version.getVersion());
            this.printlnEndTag(TAG_LIBS);
            this.printlnStartTag(TAG_JAVA);
            Set<Object> tmpKeys = System.getProperties().keySet();
            ArrayList<String> tmpProperties = new ArrayList<String>(tmpKeys.size());
            for (Object tmpObject : tmpKeys) {
                tmpProperties.add(tmpObject.toString());
            }
            Collections.sort(tmpProperties);
            for (String tmpProperty : tmpProperties) {
                String tmpValue = System.getProperty(tmpProperty);
                tmpValue = tmpValue.replace("\n", "\\n");
                tmpValue = tmpValue.replace("\r", "\\r");
                tmpValue = tmpValue.replace("\t", "\\t");
                this.printConfigurationProperty(tmpProperty, tmpValue);
            }
            this.printlnEndTag(TAG_JAVA);
            this.printlnEndTag(TAG_ABOUT);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void start(WetatorEngine aWetatorEngine) {
        try {
            WetatorConfiguration tmpConfiguration = aWetatorEngine.getConfiguration();
            this.printlnStartTag(TAG_CONFIGURATION);
            File tmpSrc = tmpConfiguration.getSourceFile();
            if (null != tmpSrc) {
                this.printConfigurationProperty("configuration file", FilenameUtils.normalize((String)tmpSrc.getAbsolutePath()));
            }
            this.printConfigurationProperty("wetator.baseUrl", tmpConfiguration.getBaseUrl());
            for (IBrowser.BrowserType browserType : tmpConfiguration.getBrowserTypes()) {
                this.printConfigurationProperty("wetator.browser", browserType.getLabel());
            }
            this.printConfigurationProperty("wetator.acceptLanguage", tmpConfiguration.getAcceptLanaguage());
            this.printConfigurationProperty("wetator.outputDir", FilenameUtils.normalize((String)tmpConfiguration.getOutputDir().getAbsolutePath()));
            this.printConfigurationProperty("wetator.jsTimeout", tmpConfiguration.getJsTimeoutInSeconds() + "s");
            this.printConfigurationProperty("wetator.httpTimeout", tmpConfiguration.getHttpTimeoutInSeconds() + "s");
            this.printConfigurationProperty("wetator.wpath.separator", tmpConfiguration.getWPathSeparator());
            if (tmpConfiguration.getXslTemplates().isEmpty()) {
                this.printConfigurationProperty("wetator.xslTemplates", "");
            } else {
                for (String string : tmpConfiguration.getXslTemplates()) {
                    this.printConfigurationProperty("wetator.xslTemplates", string);
                }
            }
            if (tmpConfiguration.getCommandSets().isEmpty()) {
                this.printConfigurationProperty("wetator.commandSets", "");
            } else {
                for (ICommandSet iCommandSet : tmpConfiguration.getCommandSets()) {
                    this.printConfigurationProperty("wetator.commandSets", iCommandSet.getClass().getName());
                }
            }
            if (tmpConfiguration.getControls().isEmpty()) {
                this.printConfigurationProperty("wetator.controls", "");
            } else {
                for (Class clazz : tmpConfiguration.getControls()) {
                    this.printConfigurationProperty("wetator.controls", clazz.getName());
                }
            }
            if (tmpConfiguration.getScripters().isEmpty()) {
                this.printConfigurationProperty("wetator.scripters", "");
            } else {
                for (IScripter iScripter : tmpConfiguration.getScripters()) {
                    this.printConfigurationProperty("wetator.scripters", iScripter.getClass().getName());
                }
            }
            this.printConfigurationProperty("wetator.proxyHost", tmpConfiguration.getProxyHost());
            this.printConfigurationProperty("wetator.proxyPort", Integer.toString(tmpConfiguration.getProxyPort()));
            if (tmpConfiguration.getProxyHostsToBypass() == null || tmpConfiguration.getProxyHostsToBypass().isEmpty()) {
                this.printConfigurationProperty("wetator.proxyHostsToBypass", "");
            } else {
                for (String string : tmpConfiguration.getProxyHostsToBypass()) {
                    this.printConfigurationProperty("wetator.proxyHostsToBypass", string);
                }
            }
            this.printConfigurationProperty("wetator.proxyUser", tmpConfiguration.getProxyUser());
            this.printConfigurationProperty("wetator.basicAuthUser", tmpConfiguration.getBasicAuthUser());
            this.printConfigurationProperty("wetator.ntlmUser", tmpConfiguration.getNtlmUser());
            this.printConfigurationProperty("wetator.ntlmWorkstation", tmpConfiguration.getNtlmWorkstation());
            this.printConfigurationProperty("wetator.ntlmDomain", tmpConfiguration.getNtlmDomain());
            this.printConfigurationProperty("wetator.retrospect", Integer.toString(tmpConfiguration.getRetrospect()));
            this.printConfigurationProperty("wetator.jsDebugger", Boolean.toString(tmpConfiguration.startJsDebugger()));
            for (Map.Entry entry : tmpConfiguration.getMimeTypes().entrySet()) {
                this.printStartTagOpener(TAG_MIME_TYPE);
                this.output.print(" extension=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue((String)entry.getKey()));
                this.output.print("\" type=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue((String)entry.getValue()));
                this.output.println("\"/>");
            }
            this.printlnStartTag(TAG_VARIABLES);
            List<Variable> tmpVariables = tmpConfiguration.getVariables();
            for (Variable variable : tmpVariables) {
                this.printStartTagOpener(TAG_VARIABLE);
                this.output.print(" name=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue(variable.getName()));
                this.output.print("\" value=\"");
                String tmpValue = variable.getValue().toString();
                tmpValue = tmpValue.replace("\n", "\\n");
                tmpValue = tmpValue.replace("\r", "\\r");
                tmpValue = tmpValue.replace("\t", "\\t");
                this.output.print(this.xmlUtil.normalizeAttributeValue(tmpValue));
                this.output.println("\"/>");
            }
            this.printlnEndTag(TAG_VARIABLES);
            List<ICommandSet> list = tmpConfiguration.getCommandSets();
            for (ICommandSet tmpCommandSet : list) {
                this.printStartTagOpener(TAG_COMMAND_SET);
                this.output.print(" class=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue(tmpCommandSet.getClass().toString()));
                this.output.println("\">");
                this.output.indent();
                for (String tmpMessage : tmpCommandSet.getInitializationMessages()) {
                    this.printLogMessage("INFO", tmpMessage);
                }
                this.printlnEndTag(TAG_COMMAND_SET);
            }
            List<Class<? extends IControl>> list2 = tmpConfiguration.getControls();
            for (Class<? extends IControl> tmpControl : list2) {
                this.printStartTagOpener(TAG_CONTROL);
                this.output.print(" class=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue(tmpControl.getClass().toString()));
                this.output.println("\"/>");
            }
            this.printlnEndTag(TAG_CONFIGURATION);
            this.printlnNode(TAG_START_TIME, StringUtil.formatDate(new Date()));
            for (TestCase tmpTestCase : aWetatorEngine.getTestCases()) {
                this.printlnNode(TAG_TEST_FILE, FilenameUtils.normalize((String)tmpTestCase.getFile().getAbsolutePath()));
            }
            this.executionStartTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testCaseStart(TestCase aTestCase) {
        try {
            this.printStartTagOpener(TAG_TESTCASE);
            this.output.print(" name=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aTestCase.getName()));
            this.output.print("\" file=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(FilenameUtils.normalize((String)aTestCase.getFile().getAbsolutePath())));
            this.output.println("\">");
            this.output.indent();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testRunStart(String aBrowserName) {
        try {
            this.printStartTagOpener(TAG_TESTRUN);
            this.output.print(" browser=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aBrowserName));
            this.output.println("\">");
            this.output.indent();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testFileStart(String aFileName) {
        try {
            this.printStartTagOpener(TAG_TESTFILE);
            this.output.print(" file=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aFileName));
            this.output.println("\">");
            this.output.indent();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeCommandStart(WetatorContext aContext, Command aCommand) {
        try {
            this.printStartTagOpener(TAG_COMMAND);
            this.output.print(" name=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aCommand.getName()));
            this.output.print("\" line=\"" + aCommand.getLineNo());
            if (aCommand.isComment()) {
                this.output.print("\" isComment=\"true");
            }
            this.output.println("\">");
            this.output.indent();
            Parameter tmpParameter = aCommand.getFirstParameter();
            this.printStartTag(TAG_FIRST_PARAM);
            if (null != tmpParameter) {
                this.output.print(this.xmlUtil.normalizeBodyValue(tmpParameter.getValue(aContext).toString()));
            }
            this.printEndTag(TAG_FIRST_PARAM);
            this.output.println();
            tmpParameter = aCommand.getSecondParameter();
            this.printStartTag(TAG_SECOND_PARAM);
            if (null != tmpParameter) {
                this.output.print(this.xmlUtil.normalizeBodyValue(tmpParameter.getValue(aContext).toString()));
            }
            this.printEndTag(TAG_SECOND_PARAM);
            this.output.println();
            tmpParameter = aCommand.getThirdParameter();
            this.printStartTag(TAG_THIRD_PARAM);
            if (null != tmpParameter) {
                this.output.print(this.xmlUtil.normalizeBodyValue(tmpParameter.getValue(aContext).toString()));
            }
            this.printEndTag(TAG_THIRD_PARAM);
            this.output.println();
            this.commandExecutionStartTimes.push(System.currentTimeMillis());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeCommandSuccess() {
    }

    @Override
    public void executeCommandIgnored() {
        try {
            this.printStartTagOpener(TAG_IGNORED);
            this.output.println("/>");
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeCommandFailure(AssertionException anAssertionException) {
        try {
            this.printFailureStart(anAssertionException);
            Throwable tmpThrowable = anAssertionException.getCause();
            if (null != tmpThrowable) {
                this.printErrorMessageStack(tmpThrowable);
            }
            this.printFailureEnd();
            this.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeCommandError(Throwable aThrowable) {
        try {
            this.printErrorStart(aThrowable);
            this.printErrorMessageStack(aThrowable.getCause());
            this.printlnNode(TAG_ERROR_DETAILS, ExceptionUtils.getStackTrace((Throwable)aThrowable));
            this.printErrorEnd();
            this.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeCommandEnd() {
        try {
            this.printlnNode(TAG_EXECUTION_TIME, Long.toString(System.currentTimeMillis() - this.commandExecutionStartTimes.pop()));
            this.printlnEndTag(TAG_COMMAND);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testFileEnd() {
        try {
            this.printlnEndTag(TAG_TESTFILE);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testRunIgnored() {
        try {
            this.printStartTagOpener(TAG_IGNORED);
            this.output.println("/>");
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testRunEnd() {
        try {
            this.printlnEndTag(TAG_TESTRUN);
            this.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void testCaseEnd() {
        try {
            this.printlnEndTag(TAG_TESTCASE);
            this.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void end(WetatorEngine aWetatorEngine) {
        try {
            this.printlnNode(TAG_EXECUTION_TIME, Long.toString(System.currentTimeMillis() - this.executionStartTime));
            this.output.println("<!--");
            this.output.println(SearchPattern.getStatistics());
            this.output.println("-->");
            this.printlnEndTag(TAG_WET);
            this.output.close();
            if (!this.xslTemplates.isEmpty()) {
                XSLTransformer tmpXSLTransformer = new XSLTransformer(this.resultFile);
                tmpXSLTransformer.transform(this.xslTemplates, this.outputDir);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void responseStored(String aResponseFileName) {
        try {
            this.printlnNode(TAG_RESPONSE, aResponseFileName);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void highlightedResponse(String aResponseFileName) {
        try {
            this.printlnNode(TAG_HIGHLIGHT, aResponseFileName);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void error(Throwable aThrowable) {
        try {
            this.printErrorStart(aThrowable);
            this.printErrorMessageStack(aThrowable.getCause());
            this.printlnNode(TAG_ERROR_DETAILS, ExceptionUtils.getStackTrace((Throwable)aThrowable));
            this.printErrorEnd();
            this.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void warn(String aMessageKey, Object[] aParameters, String aDetails) {
        try {
            String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
            if (LOG.isWarnEnabled()) {
                LOG.warn(tmpMessage);
            }
            this.printlnStartTag(TAG_LOG);
            this.printlnNode(TAG_LEVEL, "WARN");
            this.printlnNode(TAG_MESSAGE, tmpMessage);
            if (null != aDetails) {
                this.printlnNode(TAG_ERROR_DETAILS, aDetails);
            }
            this.printlnEndTag(TAG_LOG);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void info(String aMessageKey, Object ... aParameters) {
        try {
            String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
            if (LOG.isInfoEnabled()) {
                LOG.info(tmpMessage);
            }
            this.printLogMessage("INFO", tmpMessage);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void htmlDescribe(String aHtmlDescription) {
        try {
            this.printStartTag(TAG_DESCRIBE);
            this.output.print(aHtmlDescription);
            this.printlnEndTag(TAG_DESCRIBE);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void printLogMessage(String aLevel, String aMessage) throws IOException {
        this.printlnStartTag(TAG_LOG);
        this.printlnNode(TAG_LEVEL, aLevel);
        this.printlnNode(TAG_MESSAGE, aMessage);
        this.printlnEndTag(TAG_LOG);
    }

    private void printFailureStart(AssertionException anAssertionException) throws IOException {
        this.printlnStartTag(TAG_FAILURE);
        String tmpMessage = anAssertionException.getMessage();
        if (StringUtils.isBlank((CharSequence)tmpMessage)) {
            tmpMessage = anAssertionException.toString();
        }
        this.printlnNode(TAG_MESSAGE, tmpMessage);
    }

    private void printFailureEnd() throws IOException {
        this.printlnEndTag(TAG_FAILURE);
    }

    private void printErrorStart(Throwable aThrowable) throws IOException {
        this.printlnStartTag(TAG_ERROR);
        String tmpMessage = aThrowable.getMessage();
        if (StringUtils.isBlank((CharSequence)tmpMessage)) {
            tmpMessage = aThrowable.toString();
        }
        this.printlnNode(TAG_MESSAGE, tmpMessage);
    }

    private void printErrorEnd() throws IOException {
        this.printlnEndTag(TAG_ERROR);
    }

    private void printErrorMessageStack(Throwable aThrowable) {
        if (null == aThrowable) {
            return;
        }
        try {
            this.printErrorStart(aThrowable);
            Throwable tmpThrowable = aThrowable.getCause();
            if (null != tmpThrowable) {
                this.printErrorMessageStack(tmpThrowable);
            }
            this.printErrorEnd();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void printConfigurationProperty(String aKey, String aValue) throws IOException {
        this.printStartTagOpener(TAG_PROPERTY);
        this.output.print(" key=\"");
        this.output.print(this.xmlUtil.normalizeAttributeValue(aKey));
        if (null != aValue) {
            this.output.print("\" value=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aValue));
        }
        this.output.println("\" />");
    }

    private void printConfigurationProperty(String aKey, SecretString aValue) throws IOException {
        this.printStartTagOpener(TAG_PROPERTY);
        this.output.print(" key=\"");
        this.output.print(this.xmlUtil.normalizeAttributeValue(aKey));
        if (null != aValue) {
            this.output.print("\" value=\"");
            this.output.print(this.xmlUtil.normalizeAttributeValue(aValue.toString()));
        }
        this.output.println("\" />");
    }

    private void printlnNode(String aNodeName, String aNodeValue) throws IOException {
        this.printStartTag(aNodeName);
        this.output.print(this.xmlUtil.normalizeBodyValue(aNodeValue));
        this.printEndTag(aNodeName);
        this.output.println();
    }

    private void printlnStartTag(String aName) throws IOException {
        this.printStartTag(aName);
        this.output.println();
        this.output.indent();
    }

    private void printStartTag(String aName) throws IOException {
        this.printStartTagOpener(aName);
        this.output.print(">");
    }

    private void printlnEndTag(String aName) throws IOException {
        this.output.unindent();
        this.printEndTag(aName);
        this.output.println();
    }

    private void printEndTag(String aName) throws IOException {
        this.output.print("</").print(aName).print(">");
    }

    private void printStartTagOpener(String aName) throws IOException {
        this.output.print("<").print(aName).print(" id=\"" + this.tagId++).print("\"");
    }

    private void flush() throws IOException {
        this.output.flush();
    }
}

