/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import dk.brics.automaton.RunAutomaton;
import org.wetator.core.searchpattern.AbstractAutomatonMatcher;

public final class AutomatonFromEndMatcher
extends AbstractAutomatonMatcher {
    public AutomatonFromEndMatcher(CharSequence aCharSequence, RunAutomaton anAutomaton) {
        this(aCharSequence, 0, anAutomaton);
    }

    public AutomatonFromEndMatcher(CharSequence aCharSequence, int anOffset, RunAutomaton anAutomaton) {
        super(aCharSequence, anAutomaton);
        this.matchEnd = Math.max(this.chars.length(), this.chars.length() - anOffset);
    }

    public boolean find() {
        if (this.matchStart == -2) {
            return false;
        }
        int tmpLength = this.chars.length();
        int tmpBegin = this.matchStart == -1 ? tmpLength : this.matchStart - 1;
        if (tmpBegin < 0) {
            return false;
        }
        boolean tmpFound = false;
        int tmpMatchEnd = -1;
        while (tmpBegin > -1) {
            tmpMatchEnd = this.findAt(tmpBegin);
            if (tmpMatchEnd == -1) {
                if (tmpFound) {
                    return true;
                }
            } else {
                if (tmpFound && tmpMatchEnd != this.matchEnd) {
                    return true;
                }
                this.setMatch(tmpBegin, tmpMatchEnd);
                tmpFound = true;
            }
            --tmpBegin;
        }
        if (tmpMatchEnd != -1) {
            this.setMatch(tmpBegin + 1, tmpMatchEnd);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private int findAt(int aPos) {
        int tmpNewState;
        int tmpMatchEnd = -1;
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            tmpMatchEnd = aPos;
        }
        int tmpLength = this.chars.length();
        int tmpState = this.automaton.getInitialState();
        for (int i = aPos; i < tmpLength && (tmpNewState = this.automaton.step(tmpState, this.chars.charAt(i))) != -1; ++i) {
            if (this.automaton.isAccept(tmpNewState)) {
                tmpMatchEnd = i + 1;
            }
            tmpState = tmpNewState;
        }
        return tmpMatchEnd;
    }
}

