/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.commandset.DefaultCommandSet;
import org.wetator.core.ICommandSet;
import org.wetator.core.IScripter;
import org.wetator.core.Variable;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.ConfigurationException;
import org.wetator.scripter.ExcelScripter;
import org.wetator.scripter.LegacyXMLScripter;
import org.wetator.scripter.WikiTextScripter;
import org.wetator.scripter.XMLScripter;
import org.wetator.util.FileUtil;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;

public class WetatorConfiguration {
    private static final Logger LOG = LogManager.getLogger(WetatorConfiguration.class);
    public static final String PROPERTY_PREFIX = "wetator.";
    public static final String PROPERTY_COMMAND_SETS = "wetator.commandSets";
    public static final String PROPERTY_WPATH_SEPARATOR = "wetator.wpath.separator";
    public static final String DEFAULT_WPATH_SEPARATOR = ">";
    public static final String PROPERTY_CONTROLS = "wetator.controls";
    public static final String PROPERTY_SCRIPTERS = "wetator.scripters";
    public static final String PROPERTY_BASE_URL = "wetator.baseUrl";
    public static final String PROPERTY_TYPING_SPEED = "wetator.typingSpeed";
    public static final String PROPERTY_JAVASCRIPT_TIMEOUT = "wetator.jsTimeout";
    public static final String PROPERTY_HTTP_TIMEOUT = "wetator.httpTimeout";
    public static final String PROPERTY_OUTPUT_DIR = "wetator.outputDir";
    private static final String DEFAULT_OUTPUT_DIR = "./logs";
    public static final String PROPERTY_DISTINCT_OUTPUT = "wetator.distinctOutput";
    private static final String DEFAULT_DISTINCT_OUTPUT = "false";
    public static final String PROPERTY_XSL_TEMPLATES = "wetator.xslTemplates";
    public static final String PROPERTY_JS_DEBUGGER = "wetator.jsDebugger";
    public static final String PROPERTY_RETROSPECT = "wetator.retrospect";
    public static final String PROPERTY_BROWSER_TYPE = "wetator.browser";
    private static final IBrowser.BrowserType DEFAULT_BROWSER_TYPE = IBrowser.BrowserType.FIREFOX_ESR;
    public static final String PROPERTY_BROWSER_ACTIVEXOBJECTS = "wetator.browser.activeXObjects";
    public static final String PROPERTY_ACCEPT_LANGUAGE = "wetator.acceptLanguage";
    private static final String DEFAULT_ACCEPT_LANGUAGE = "en-us,en;q=0.8,de-de;q=0.5,de;q=0.3";
    public static final String PROPERTY_BASIC_AUTH_USER = "wetator.basicAuthUser";
    private static final String PROPERTY_BASIC_AUTH_PASSWORD = "wetator.basicAuthPassword";
    public static final String PROPERTY_NTLM_USER = "wetator.ntlmUser";
    private static final String PROPERTY_NTLM_PASSWORD = "wetator.ntlmPassword";
    public static final String PROPERTY_NTLM_WORKSTATION = "wetator.ntlmWorkstation";
    public static final String PROPERTY_NTLM_DOMAIN = "wetator.ntlmDomain";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL = "wetator.clientCertificateKeyStoreUrl";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE = "wetator.clientCertificateKeyStoreType";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD = "wetator.clientCertificateKeyStorePassword";
    public static final String PROPERTY_PROXY_HOST = "wetator.proxyHost";
    public static final String PROPERTY_PROXY_PORT = "wetator.proxyPort";
    public static final String PROPERTY_PROXY_HOSTS_TO_BYPASS = "wetator.proxyHostsToBypass";
    public static final String PROPERTY_PROXY_USER = "wetator.proxyUser";
    private static final String PROPERTY_PROXY_PASSWORD = "wetator.proxyPassword";
    private static final String PROPERTY_JS_JOB_FILTER_FILE = "wetator.jsJobFilterFile";
    public static final String PROPERTY_UPLOAD_MIME_TYPE = "wetator.uploadMimeType";
    public static final String VARIABLE_PREFIX = "$";
    public static final String SECRET_PREFIX = "$";
    private File sourceFile;
    private List<IScripter> scripters;
    private List<ICommandSet> commandSets;
    private List<Class<? extends IControl>> controls;
    private String baseUrl;
    private int jsTimeoutInSeconds;
    private int httpTimeoutInSeconds;
    private int typingSpeedInKeystrokesPerMinute;
    private String wpathSeparator;
    private File outputDir;
    private List<String> xslTemplates;
    private List<IBrowser.BrowserType> browserTypes;
    private Map<String, String> browserActiveXObjects;
    private String acceptLanaguage;
    private SecretString basicAuthUser;
    private SecretString basicAuthPassword;
    private SecretString ntlmUser;
    private SecretString ntlmPassword;
    private SecretString ntlmWorkstation;
    private SecretString ntlmDomain;
    private String proxyHost;
    private int proxyPort;
    private Set<String> proxyHostsToBypass;
    private SecretString proxyUser;
    private SecretString proxyPassword;
    private String clientCertificateKeyStoreUrl;
    private String clientCertificateKeyStoreType;
    private SecretString clientCertificateKeyStorePassword;
    private Set<SearchPattern> jsJobFilterPatterns;
    private boolean jsDebugger;
    private Map<String, String> mimeTypes;
    private List<Variable> variables;
    private boolean debugLogging;
    private int retrospect;

    public WetatorConfiguration(File aConfigurationPropertyFile, Map<String, String> anExternalPropertiesMap) {
        File tmpBaseDirectory;
        Properties tmpProperties;
        LOG.info("Configuration: Configuration file is '" + FilenameUtils.normalize((String)aConfigurationPropertyFile.getAbsolutePath()) + "'");
        if (!aConfigurationPropertyFile.exists()) {
            throw new ConfigurationException("The configuration file '" + FilenameUtils.normalize((String)aConfigurationPropertyFile.getAbsolutePath()) + "' does not exist.");
        }
        if (!aConfigurationPropertyFile.canRead()) {
            throw new ConfigurationException("The configuration file '" + FilenameUtils.normalize((String)aConfigurationPropertyFile.getAbsolutePath()) + "' is not readable.");
        }
        try (InputStream tmpFileInputStream = Files.newInputStream(aConfigurationPropertyFile.toPath(), new OpenOption[0]);){
            tmpProperties = new Properties();
            tmpProperties.load(tmpFileInputStream);
            tmpBaseDirectory = aConfigurationPropertyFile.getParentFile();
            if (null == tmpBaseDirectory) {
                tmpBaseDirectory = new File(System.getProperty("user.dir"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("An error occured during read of the configuration file '" + aConfigurationPropertyFile.getAbsolutePath() + "'.", e);
        }
        this.sourceFile = aConfigurationPropertyFile;
        this.initialize(tmpBaseDirectory, tmpProperties, anExternalPropertiesMap);
    }

    public WetatorConfiguration(File aBaseDirectory, Properties aConfigurationProperties, Map<String, String> anExternalPropertiesMap) {
        this.initialize(aBaseDirectory, aConfigurationProperties, anExternalPropertiesMap);
    }

    private void initialize(File aBaseDirectory, Properties aConfigurationProperties, Map<String, String> anExternalPropertiesMap) {
        if (!aBaseDirectory.exists()) {
            throw new ConfigurationException("The base directory '" + FilenameUtils.normalize((String)aBaseDirectory.getAbsolutePath()) + "' does not exist.");
        }
        if (!aBaseDirectory.isDirectory()) {
            throw new ConfigurationException("The base directory '" + FilenameUtils.normalize((String)aBaseDirectory.getAbsolutePath()) + "' is not a directory.");
        }
        if (!aBaseDirectory.canRead()) {
            throw new ConfigurationException("The base directory '" + FilenameUtils.normalize((String)aBaseDirectory.getAbsolutePath()) + "' is not readable.");
        }
        if (!aBaseDirectory.canWrite()) {
            throw new ConfigurationException("The base directory '" + FilenameUtils.normalize((String)aBaseDirectory.getAbsolutePath()) + "' is not writable.");
        }
        LOG.info("Configuration: Base directory is '" + FilenameUtils.normalize((String)aBaseDirectory.getAbsolutePath()) + "'");
        Properties tmpProperties = aConfigurationProperties;
        Set<Object> tmpSystemPropertyNames = System.getProperties().keySet();
        for (Object object : tmpSystemPropertyNames) {
            String tmpPropertyValue;
            String tmpKeyName = (String)object;
            if (!tmpKeyName.startsWith(PROPERTY_PREFIX) && !tmpKeyName.startsWith("$") || null == (tmpPropertyValue = System.getProperty(tmpKeyName))) continue;
            tmpProperties.put(tmpKeyName, tmpPropertyValue);
        }
        if (null != anExternalPropertiesMap) {
            Iterator<ICommandSet> tmpExternalPropertiesNames = anExternalPropertiesMap.keySet();
            Iterator<String> iterator = tmpExternalPropertiesNames.iterator();
            while (iterator.hasNext()) {
                String string;
                String tmpKey2 = iterator.next();
                String tmpKeyName = tmpKey2;
                if (!tmpKeyName.startsWith(PROPERTY_PREFIX) && !tmpKeyName.startsWith("$") || null == (string = anExternalPropertiesMap.get(tmpKeyName))) continue;
                tmpProperties.put(tmpKeyName, string);
            }
        }
        this.scripters = new LinkedList<IScripter>();
        this.readScripters(tmpProperties);
        for (IScripter iScripter : this.scripters) {
            iScripter.initialize(tmpProperties);
        }
        this.commandSets = new LinkedList<ICommandSet>();
        this.readCommandSets(tmpProperties);
        for (ICommandSet iCommandSet : this.commandSets) {
            iCommandSet.initialize(tmpProperties);
        }
        this.controls = new LinkedList<Class<? extends IControl>>();
        this.readControls(tmpProperties);
        this.wpathSeparator = tmpProperties.getProperty(PROPERTY_WPATH_SEPARATOR, DEFAULT_WPATH_SEPARATOR);
        String tmpValue = tmpProperties.getProperty(PROPERTY_OUTPUT_DIR, DEFAULT_OUTPUT_DIR);
        this.outputDir = new File(tmpValue);
        if (!this.outputDir.isAbsolute()) {
            this.outputDir = new File(aBaseDirectory, tmpValue);
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_DISTINCT_OUTPUT, DEFAULT_DISTINCT_OUTPUT);
        boolean bl = Boolean.parseBoolean(tmpValue);
        LOG.info("Configuration: DistinctOutput is '" + bl + "'");
        if (bl) {
            SimpleDateFormat tmpFormater = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.ROOT);
            this.outputDir = new File(this.outputDir, tmpFormater.format(new Date()));
        }
        try {
            FileUtil.createOutputDir(this.outputDir);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not create output directory '" + FilenameUtils.normalize((String)this.outputDir.getAbsolutePath()) + "'.", e);
        }
        LOG.info("Configuration: OutputDir is '" + FilenameUtils.normalize((String)this.outputDir.getAbsolutePath()) + "'");
        tmpValue = tmpProperties.getProperty(PROPERTY_BASE_URL, "");
        tmpProperties.remove(PROPERTY_BASE_URL);
        if (StringUtils.isEmpty((CharSequence)tmpValue)) {
            throw new ConfigurationException("The required property 'wetator.baseUrl' is not set.");
        }
        this.baseUrl = tmpValue;
        tmpValue = tmpProperties.getProperty(PROPERTY_TYPING_SPEED, "200");
        tmpProperties.remove(PROPERTY_TYPING_SPEED);
        try {
            this.typingSpeedInKeystrokesPerMinute = Integer.parseInt(tmpValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The property 'wetator.typingSpeed' is no integer.");
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_JAVASCRIPT_TIMEOUT, "1");
        try {
            this.jsTimeoutInSeconds = Integer.parseInt(tmpValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The property 'wetator.jsTimeout' is no integer.");
        }
        if (this.jsTimeoutInSeconds < 1) {
            throw new ConfigurationException("The property 'wetator.jsTimeout' is less than 1.");
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_HTTP_TIMEOUT, "90");
        try {
            this.httpTimeoutInSeconds = Integer.parseInt(tmpValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The property 'wetator.httpTimeout' is no integer.");
        }
        if (this.httpTimeoutInSeconds < 1) {
            throw new ConfigurationException("The property 'wetator.httpTimeout' is less than 1.");
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_BROWSER_TYPE, "");
        tmpProperties.remove(PROPERTY_BROWSER_TYPE);
        this.browserTypes = new ArrayList<IBrowser.BrowserType>();
        List<String> tmpParts = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String string : tmpParts) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            IBrowser.BrowserType tmpBrowserType = IBrowser.BrowserType.getForSymbol(string);
            if (null == tmpBrowserType) {
                LOG.warn("Unsupported browser '" + string + "'.");
                continue;
            }
            this.browserTypes.add(tmpBrowserType);
        }
        if (this.browserTypes.isEmpty()) {
            this.browserTypes.add(DEFAULT_BROWSER_TYPE);
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_BROWSER_ACTIVEXOBJECTS, "");
        tmpProperties.remove(PROPERTY_BROWSER_ACTIVEXOBJECTS);
        this.browserActiveXObjects = new HashMap<String, String>();
        tmpParts = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String string : tmpParts) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            List<String> tmpPices = StringUtil.extractStrings(tmpValue, "|", 92);
            if (tmpPices.size() != 2) {
                throw new ConfigurationException("The configured activeX object '" + tmpValue + "' does not have two parts (separated by '|').");
            }
            String tmpClsId = tmpPices.get(0);
            if (StringUtils.isBlank((CharSequence)tmpClsId)) {
                throw new ConfigurationException("The configured class id of the activeX object '" + tmpValue + "' is blank.");
            }
            String tmpMockClass = tmpPices.get(1).trim();
            try {
                Class.forName(tmpMockClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("The configured activeX java class '" + tmpValue + "' is not available/loadable (details: " + e.toString() + ".");
            }
            this.browserActiveXObjects.put(tmpClsId.trim(), tmpMockClass);
        }
        this.browserActiveXObjects = Collections.unmodifiableMap(this.browserActiveXObjects);
        tmpValue = tmpProperties.getProperty(PROPERTY_ACCEPT_LANGUAGE, DEFAULT_ACCEPT_LANGUAGE);
        tmpProperties.remove(PROPERTY_ACCEPT_LANGUAGE);
        this.acceptLanaguage = tmpValue;
        tmpValue = tmpProperties.getProperty(PROPERTY_PROXY_HOST, "");
        tmpProperties.remove(PROPERTY_PROXY_HOST);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.proxyHost = tmpValue;
            tmpValue = tmpProperties.getProperty(PROPERTY_PROXY_PORT, "");
            tmpProperties.remove(PROPERTY_PROXY_PORT);
            try {
                this.proxyPort = Integer.parseInt(tmpValue);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("The property 'wetator.proxyPort' is no integer.");
            }
            this.proxyHostsToBypass = new HashSet<String>();
            tmpValue = tmpProperties.getProperty(PROPERTY_PROXY_HOSTS_TO_BYPASS, "");
            tmpProperties.remove(PROPERTY_PROXY_HOSTS_TO_BYPASS);
            if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
                String[] tmpNonProxyHostArray = tmpValue.split("\\|");
                for (String tmpHost : tmpNonProxyHostArray) {
                    if (!StringUtils.isNotBlank((CharSequence)tmpHost)) continue;
                    this.proxyHostsToBypass.add(tmpHost.trim());
                }
            }
            tmpValue = tmpProperties.getProperty(PROPERTY_PROXY_USER, "");
            tmpProperties.remove(PROPERTY_PROXY_USER);
            if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
                this.proxyUser = new SecretString(tmpValue);
                tmpValue = tmpProperties.getProperty(PROPERTY_PROXY_PASSWORD, "");
                tmpProperties.remove(PROPERTY_PROXY_PASSWORD);
                this.proxyPassword = new SecretString().appendSecret(tmpValue);
            }
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_BASIC_AUTH_USER, "");
        tmpProperties.remove(PROPERTY_BASIC_AUTH_USER);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.basicAuthUser = new SecretString(tmpValue);
            tmpValue = tmpProperties.getProperty(PROPERTY_BASIC_AUTH_PASSWORD, "");
            tmpProperties.remove(PROPERTY_BASIC_AUTH_PASSWORD);
            this.basicAuthPassword = new SecretString().appendSecret(tmpValue);
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_NTLM_USER, "");
        tmpProperties.remove(PROPERTY_NTLM_USER);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.ntlmUser = new SecretString(tmpValue);
            tmpValue = tmpProperties.getProperty(PROPERTY_NTLM_PASSWORD, "");
            tmpProperties.remove(PROPERTY_NTLM_PASSWORD);
            this.ntlmPassword = new SecretString().appendSecret(tmpValue);
            tmpValue = tmpProperties.getProperty(PROPERTY_NTLM_WORKSTATION, "");
            tmpProperties.remove(PROPERTY_NTLM_WORKSTATION);
            this.ntlmWorkstation = new SecretString(tmpValue);
            tmpValue = tmpProperties.getProperty(PROPERTY_NTLM_DOMAIN, "");
            tmpProperties.remove(PROPERTY_NTLM_DOMAIN);
            this.ntlmDomain = new SecretString(tmpValue);
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL, "");
        tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.clientCertificateKeyStoreUrl = tmpValue;
            tmpValue = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE, "");
            tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE);
            this.clientCertificateKeyStoreType = tmpValue;
            tmpValue = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD, null);
            tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD);
            this.clientCertificateKeyStorePassword = new SecretString().appendSecret(tmpValue);
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_XSL_TEMPLATES, "");
        tmpProperties.remove(PROPERTY_XSL_TEMPLATES);
        this.xslTemplates = new LinkedList<String>();
        tmpParts = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String string : tmpParts) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            File tmpTemplateFile = new File(string);
            if (!tmpTemplateFile.isAbsolute()) {
                tmpTemplateFile = new File(aBaseDirectory, string);
            }
            if (!tmpTemplateFile.exists()) {
                throw new ConfigurationException("The configured XSL template '" + FilenameUtils.normalize((String)tmpTemplateFile.getAbsolutePath()) + "' does not exist.");
            }
            if (!tmpTemplateFile.canRead()) {
                throw new ConfigurationException("The configured XSL template '" + FilenameUtils.normalize((String)tmpTemplateFile.getAbsolutePath()) + "' is not readable.");
            }
            this.xslTemplates.add(FilenameUtils.normalize((String)tmpTemplateFile.getAbsolutePath()));
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_JS_JOB_FILTER_FILE, "");
        tmpProperties.remove(PROPERTY_JS_JOB_FILTER_FILE);
        this.jsJobFilterPatterns = new HashSet<SearchPattern>();
        if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
            File tmpFilterFile = new File(tmpValue);
            if (!tmpFilterFile.isAbsolute()) {
                tmpFilterFile = new File(aBaseDirectory, tmpValue);
            }
            if (!tmpFilterFile.exists()) {
                throw new ConfigurationException("The configured jsJob filter file '" + FilenameUtils.normalize((String)tmpFilterFile.getAbsolutePath()) + "' does not exist.");
            }
            if (!tmpFilterFile.canRead()) {
                throw new ConfigurationException("The configured jsJob filter '" + FilenameUtils.normalize((String)tmpFilterFile.getAbsolutePath()) + "' is not readable.");
            }
            try {
                List list = FileUtils.readLines((File)tmpFilterFile, (Charset)StandardCharsets.UTF_8);
                for (String tmpLine : list) {
                    if (!StringUtils.isNotBlank((CharSequence)tmpLine) || tmpLine.charAt(0) == '#') continue;
                    this.jsJobFilterPatterns.add(SearchPattern.compile(tmpLine));
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Can't parse jsJob filter file '" + FilenameUtils.normalize((String)tmpFilterFile.getAbsolutePath()) + "' Reason: " + iOException.getMessage() + ".");
            }
        }
        tmpValue = tmpProperties.getProperty(PROPERTY_JS_DEBUGGER, "");
        tmpProperties.remove(PROPERTY_JS_DEBUGGER);
        this.jsDebugger = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tmpValue});
        tmpValue = tmpProperties.getProperty(PROPERTY_RETROSPECT, "-1");
        tmpProperties.remove(PROPERTY_RETROSPECT);
        try {
            this.retrospect = Integer.parseInt(tmpValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The property 'wetator.retrospect' is no integer.");
        }
        this.mimeTypes = new HashMap<String, String>();
        Set<Map.Entry<Object, Object>> tmpOtherEntries = tmpProperties.entrySet();
        for (Map.Entry<Object, Object> tmpEntry : tmpOtherEntries) {
            String tmpKey = (String)tmpEntry.getKey();
            if (!tmpKey.startsWith(PROPERTY_UPLOAD_MIME_TYPE)) continue;
            tmpKey = tmpKey.substring(PROPERTY_UPLOAD_MIME_TYPE.length() + 1);
            this.mimeTypes.put(tmpKey, (String)tmpEntry.getValue());
        }
        this.variables = new LinkedList<Variable>();
        tmpOtherEntries = tmpProperties.entrySet();
        for (Map.Entry<Object, Object> tmpEntry : tmpOtherEntries) {
            String tmpKey = (String)tmpEntry.getKey();
            String tmpVariableValue = (String)tmpEntry.getValue();
            if (!tmpKey.startsWith("$")) continue;
            if ((tmpKey = tmpKey.substring(1)).startsWith("$")) {
                this.variables.add(new Variable(tmpKey.substring(1), tmpVariableValue, true));
                continue;
            }
            this.variables.add(new Variable(tmpKey, tmpVariableValue));
        }
        LOG.debug("Configuration: Reading of the configuration finished");
    }

    private void readScripters(Properties aProperties) {
        IScripter tmpDefaultScripter = new XMLScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new LegacyXMLScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new ExcelScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new WikiTextScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        String tmpValue = aProperties.getProperty(PROPERTY_SCRIPTERS, "");
        List<String> tmpScripterClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String tmpScripterClassName : tmpScripterClassNames) {
            if (StringUtils.isEmpty((CharSequence)(tmpScripterClassName = tmpScripterClassName.trim()))) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpScripterClassName);
                Class<?> tmpScripterClass = tmpClass;
                IScripter tmpIScripter = (IScripter)tmpScripterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.scripters.add(tmpIScripter);
                LOG.info("Configuration: Scripter '" + tmpScripterClassName + "' registered.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    private void readCommandSets(Properties aProperties) {
        String tmpValue = aProperties.getProperty(PROPERTY_COMMAND_SETS, "");
        List<String> tmpCommandSetClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        tmpCommandSetClassNames.add(0, DefaultCommandSet.class.getName());
        for (String tmpCommandSetClassName : tmpCommandSetClassNames) {
            if (StringUtils.isEmpty((CharSequence)(tmpCommandSetClassName = tmpCommandSetClassName.trim()))) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpCommandSetClassName);
                Class<?> tmpCommandSetClass = tmpClass;
                ICommandSet tmpCommandSet = (ICommandSet)tmpCommandSetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.commandSets.add(tmpCommandSet);
                LOG.info("Configuration: Command set '" + tmpCommandSetClassName + "' registered.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    private void readControls(Properties aProperties) {
        String tmpValue = aProperties.getProperty(PROPERTY_CONTROLS, "");
        List<String> tmpControlClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String tmpControlClassName : tmpControlClassNames) {
            if (StringUtils.isEmpty((CharSequence)(tmpControlClassName = tmpControlClassName.trim()))) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpControlClassName);
                Class<?> tmpControlClass = tmpClass;
                this.controls.add(tmpControlClass);
                LOG.info("Configuration: Control '" + tmpControlClassName + "' registered.");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load control '" + tmpControlClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public List<ICommandSet> getCommandSets() {
        return this.commandSets;
    }

    public List<Class<? extends IControl>> getControls() {
        return this.controls;
    }

    public List<IScripter> getScripters() {
        return this.scripters;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int getJsTimeoutInSeconds() {
        return this.jsTimeoutInSeconds;
    }

    public int getHttpTimeoutInSeconds() {
        return this.httpTimeoutInSeconds;
    }

    public String getWPathSeparator() {
        return this.wpathSeparator;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public List<IBrowser.BrowserType> getBrowserTypes() {
        return this.browserTypes;
    }

    public boolean startJsDebugger() {
        return this.jsDebugger;
    }

    public Map<String, String> getBrowserActiveXObjects() {
        return this.browserActiveXObjects;
    }

    public String getAcceptLanaguage() {
        return this.acceptLanaguage;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Set<String> getProxyHostsToBypass() {
        return this.proxyHostsToBypass;
    }

    public SecretString getProxyUser() {
        return this.proxyUser;
    }

    public SecretString getProxyPassword() {
        return this.proxyPassword;
    }

    public SecretString getBasicAuthUser() {
        return this.basicAuthUser;
    }

    public SecretString getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public SecretString getNtlmUser() {
        return this.ntlmUser;
    }

    public SecretString getNtlmPassword() {
        return this.ntlmPassword;
    }

    public SecretString getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public SecretString getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getClientCertificateKeyStoreUrl() {
        return this.clientCertificateKeyStoreUrl;
    }

    public String getClientCertificateKeyStoreType() {
        return this.clientCertificateKeyStoreType;
    }

    public SecretString getClientCertificateKeyStorePassword() {
        return this.clientCertificateKeyStorePassword;
    }

    public List<String> getXslTemplates() {
        return this.xslTemplates;
    }

    public Set<SearchPattern> getJsJobFilterPatterns() {
        return this.jsJobFilterPatterns;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public int getTypingSpeedInKeystrokesPerMinute() {
        return this.typingSpeedInKeystrokesPerMinute;
    }

    public int getRetrospect() {
        return this.retrospect;
    }

    public boolean isDebugLoggingEnabled() {
        return this.debugLogging;
    }

    public void enableDebugLogging() {
        this.debugLogging = true;
    }
}

