/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.WetatorContext;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;

public final class Parameter {
    public static final String PARAMETER_DELIMITER = ",";
    public static final char PARAMETER_ESCAPE_CHAR = '\\';
    private String value;
    private List<Part> parts;

    public Parameter(String aValue) {
        this.value = aValue;
    }

    public SecretString getValue(WetatorContext aContext) {
        return aContext.replaceVariables(this.value);
    }

    public Part getFirstPart() {
        this.parseIfNeeded();
        return this.parts.get(0);
    }

    public int getNumberOfParts() {
        this.parseIfNeeded();
        return this.parts.size();
    }

    public List<Part> getParts() {
        this.parseIfNeeded();
        return Collections.unmodifiableList(this.parts);
    }

    private void parseIfNeeded() {
        if (null != this.parts) {
            return;
        }
        this.parts = new LinkedList<Part>();
        if (StringUtils.isEmpty((CharSequence)this.value)) {
            return;
        }
        List<String> tmpParts = StringUtil.extractStrings(this.value, PARAMETER_DELIMITER, 92);
        for (String tmpString : tmpParts) {
            Part tmpPart = new Part(tmpString.trim());
            this.parts.add(tmpPart);
        }
    }

    public String getValue() {
        return this.value;
    }

    public static final class Part {
        private String value;

        protected Part(String aValue) {
            this.value = aValue;
        }

        public SecretString getValue(WetatorContext aContext) {
            return aContext.replaceVariables(this.value);
        }
    }
}

