/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.wetator.core.Parameter;
import org.wetator.core.WetatorContext;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;

public final class Command {
    private String name;
    private boolean comment;
    private Parameter firstParameter;
    private Parameter secondParameter;
    private Parameter thirdParameter;
    private int lineNo;

    public Command(String aName, boolean anIsCommentFlag) {
        this.name = aName;
        this.comment = anIsCommentFlag;
        this.lineNo = -1;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int aLineNo) {
        this.lineNo = aLineNo;
    }

    public String getName() {
        return this.name;
    }

    public boolean isComment() {
        return this.comment;
    }

    public Parameter getFirstParameter() {
        return this.firstParameter;
    }

    public void setFirstParameter(Parameter aFirstParameter) {
        this.firstParameter = aFirstParameter;
    }

    public Parameter getSecondParameter() {
        return this.secondParameter;
    }

    public void setSecondParameter(Parameter aSecondParameter) {
        this.secondParameter = aSecondParameter;
    }

    public Parameter getThirdParameter() {
        return this.thirdParameter;
    }

    public void setThirdParameter(Parameter aThirdParameter) {
        this.thirdParameter = aThirdParameter;
    }

    public String toPrintableString(WetatorContext aContext) {
        StringBuilder tmpResult = new StringBuilder("[Command '").append(this.getName()).append('\'');
        if (this.comment) {
            tmpResult.append(" COMMENT");
        }
        StringBuilder tmpParams = new StringBuilder();
        Parameter tmpParameter = this.getFirstParameter();
        if (null != tmpParameter) {
            tmpParams.append(" 1: '").append(tmpParameter.getValue(aContext).toString()).append('\'');
        }
        if (null != (tmpParameter = this.getSecondParameter())) {
            tmpParams.append(" 2: '").append(this.getSecondParameter().getValue(aContext).toString()).append('\'');
        }
        if (null != (tmpParameter = this.getThirdParameter())) {
            tmpParams.append(" 3: '").append(this.getThirdParameter().getValue(aContext).toString()).append('\'');
        }
        if (tmpParams.length() == 0) {
            tmpParams.append(' ');
        }
        tmpResult.append(" params: (").append(tmpParams.substring(1)).append(")]");
        return tmpResult.toString();
    }

    public SecretString getFirstParameterValue(WetatorContext aContext) {
        return this.getParameterValue(this.getFirstParameter(), aContext);
    }

    public SecretString getRequiredFirstParameterValue(WetatorContext aContext) throws InvalidInputException {
        return this.getRequiredParameterValue(this.getFirstParameter(), aContext, "emptyFirstParameter");
    }

    public SecretString getSecondParameterValue(WetatorContext aContext) {
        return this.getParameterValue(this.getSecondParameter(), aContext);
    }

    public Long getSecondParameterLongValue(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            return null;
        }
        SecretString tmpSecondValue = tmpSecondParameter.getValue(aContext);
        if (tmpSecondValue.isEmpty()) {
            return null;
        }
        try {
            BigDecimal tmpValue = new BigDecimal(tmpSecondValue.getValue());
            return tmpValue.longValueExact();
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw Command.invalidInput("integerParameterExpected", this.getName(), tmpSecondParameter.getValue(aContext).toString(), "2");
        }
    }

    public List<SecretString> getSecondParameterValues(WetatorContext aContext) {
        Parameter tmpSecondParameter = this.getSecondParameter();
        LinkedList<SecretString> tmpResult = new LinkedList<SecretString>();
        if (null == tmpSecondParameter) {
            return tmpResult;
        }
        List<Parameter.Part> tmpParts = tmpSecondParameter.getParts();
        for (Parameter.Part tmpPart : tmpParts) {
            tmpResult.add(tmpPart.getValue(aContext));
        }
        return tmpResult;
    }

    public SecretString getRequiredSecondParameterValue(WetatorContext aContext) throws InvalidInputException {
        return this.getRequiredParameterValue(this.getSecondParameter(), aContext, "emptySecondParameter");
    }

    public List<SecretString> getRequiredSecondParameterValues(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            throw Command.invalidInput("emptySecondParameter", this.getName());
        }
        return this.getSecondParameterValues(aContext);
    }

    private SecretString getParameterValue(Parameter aParameter, WetatorContext aContext) {
        if (null == aParameter) {
            return new SecretString();
        }
        return aParameter.getValue(aContext);
    }

    private SecretString getRequiredParameterValue(Parameter aParameter, WetatorContext aContext, String anErrorMessageKey) throws InvalidInputException {
        if (null == aParameter) {
            throw Command.invalidInput(anErrorMessageKey, this.getName());
        }
        return this.getParameterValue(aParameter, aContext);
    }

    public void checkNoUnusedSecondParameter(WetatorContext aContext) throws InvalidInputException {
        this.checkNoUnusedParameter(this.getSecondParameter(), aContext, "2");
    }

    public void checkNoUnusedThirdParameter(WetatorContext aContext) throws InvalidInputException {
        this.checkNoUnusedParameter(this.getThirdParameter(), aContext, "3");
    }

    private void checkNoUnusedParameter(Parameter aParameter, WetatorContext aContext, String aParameterIndex) throws InvalidInputException {
        if (null != aParameter) {
            throw Command.invalidInput("unusedParameter", this.getName(), aParameter.getValue(aContext).toString(), aParameterIndex);
        }
    }

    private static InvalidInputException invalidInput(String aMessageKey, Object ... aParameters) {
        String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
        return new InvalidInputException(tmpMessage);
    }
}

