/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.commandset;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.ICommandSet;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;

public abstract class AbstractCommandSet
implements ICommandSet {
    private static final Logger LOG = LogManager.getLogger(AbstractCommandSet.class);
    private List<String> initializationMessages = new LinkedList<String>();
    private Map<String, ICommandImplementation> commandImplementations;
    private int noOfCommands = 0;

    protected AbstractCommandSet() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(ClassUtils.getShortClassName(this.getClass()) + " registration started");
        }
        this.commandImplementations = new HashMap<String, ICommandImplementation>();
        this.registerCommands();
        if (LOG.isDebugEnabled()) {
            LOG.debug(ClassUtils.getShortClassName(this.getClass()) + " registered; " + this.noOfCommands + " commands added");
        }
    }

    @Override
    public final ICommandImplementation getCommandImplementationFor(String aCommandName) {
        return this.commandImplementations.get(aCommandName);
    }

    @Override
    public List<String> getInitializationMessages() {
        return this.initializationMessages;
    }

    public void addInitializationMessage(String aMessage) {
        this.initializationMessages.add(aMessage);
    }

    protected abstract void registerCommands();

    protected void registerCommand(String aCommandName, ICommandImplementation aCommandImplementation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(ClassUtils.getShortClassName(this.getClass()) + " - register command : '" + aCommandName + "'");
        }
        this.commandImplementations.put(aCommandName, aCommandImplementation);
        ++this.noOfCommands;
    }

    protected IBrowser getBrowser(WetatorContext aContext) {
        return aContext.getBrowser();
    }

    protected IControlFinder getControlFinder(IBrowser aBrowser) throws ActionException {
        IControlFinder tmpControlFinder;
        try {
            tmpControlFinder = aBrowser.getControlFinder();
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
        return tmpControlFinder;
    }

    protected IControl getFirstRequiredHtmlElementFrom(WetatorContext aContext, WeightedControlList aWeightedControlList, WPath aWPath, String aNothingFoundMsgKey) throws ActionException {
        IControl tmpControl = this.getFirstHtmlElementFrom(aContext, aWeightedControlList, aWPath);
        if (null == tmpControl) {
            String tmpMessage = Messages.getMessage(aNothingFoundMsgKey, aWPath.toString());
            throw new ActionException(tmpMessage);
        }
        return tmpControl;
    }

    protected IControl getFirstHtmlElementFrom(WetatorContext aContext, WeightedControlList aWeightedControlList, WPath aWPath) {
        if (aWeightedControlList.isEmpty()) {
            return null;
        }
        List<WeightedControlList.Entry> tmpEntries = aWeightedControlList.getEntriesSorted();
        WeightedControlList.Entry tmpEntry = tmpEntries.get(0);
        if (tmpEntries.size() > 1) {
            aContext.informListenersInfo("manyElementsFound", aWPath.toString(), tmpEntry.getControl().getDescribingText());
        }
        for (WeightedControlList.Entry tmpEachEntry : tmpEntries) {
            aContext.informListenersInfo("elementFound", tmpEachEntry.toString());
        }
        return tmpEntry.getControl();
    }
}

