/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInlineQuotation;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLObjectElement;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.htmlunit.MouseAction;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;
import org.wetator.util.NormalizedString;

public class HtmlPageIndex {
    private static final Logger LOG = LogManager.getLogger(HtmlPageIndex.class);
    private static final String HIERARCHY_DELIMITER = ">";
    private static final String EVENT_NAME_CLICK = "onclick";
    private static final String EVENT_NAME_DBL_CLICK = "ondblclick";
    private static final String EVENT_NAME_CONTEXT_MENU = "oncontextmenu";
    private static final String EVENT_NAME_MOUSE_DOWN = "onmousedown";
    private static final String EVENT_NAME_MOUSE_UP = "onmouseup";
    private static final String EVENT_NAME_MOUSE_OVER = "onmouseover";
    private static final String EVENT_NAME_MOUSE_MOVE = "onmousemove";
    private static final String EVENT_NAME_MOUSE_OUT = "onmouseout";
    private HtmlPage htmlPage;
    private NormalizedString text;
    private Map<DomNode, FindSpot> positions;
    private NormalizedString textWithoutFormControls;
    private Map<DomNode, FindSpot> positionsWithoutFormControls;
    private List<DomNode> nodes;
    private Set<HtmlElement> visibleHtmlElementsBottomUp;
    private Set<HtmlElement> visibleHtmlElements;
    private Map<DomNode, String> hierarchies;
    private Map<MouseAction, Set<HtmlElement>> htmlElementsWithMouseActionListener;

    public HtmlPageIndex(HtmlPage aHtmlPage) {
        this.htmlPage = aHtmlPage;
        this.text = new NormalizedString();
        this.positions = new HashMap<DomNode, FindSpot>(256);
        this.positionsWithoutFormControls = new HashMap<DomNode, FindSpot>(256);
        this.textWithoutFormControls = new NormalizedString();
        this.nodes = new LinkedList<DomNode>();
        this.visibleHtmlElementsBottomUp = new LinkedHashSet<HtmlElement>();
        this.visibleHtmlElements = new LinkedHashSet<HtmlElement>();
        this.hierarchies = new HashMap<DomNode, String>(256);
        this.htmlElementsWithMouseActionListener = new HashMap<MouseAction, Set<HtmlElement>>();
        for (MouseAction tmpMouseAction : MouseAction.values()) {
            this.htmlElementsWithMouseActionListener.put(tmpMouseAction, new HashSet());
        }
        this.parseDomNode((DomNode)aHtmlPage, null, EnumSet.noneOf(MouseAction.class));
    }

    public <E extends HtmlElement> E getHtmlElementById(String aId) throws ElementNotFoundException {
        return (E)this.htmlPage.getHtmlElementById(aId);
    }

    public String getText() {
        return this.text.toString();
    }

    public String getTextWithoutFormControls() {
        return this.textWithoutFormControls.toString();
    }

    public Set<HtmlElement> getAllVisibleHtmlElements() {
        return this.visibleHtmlElements;
    }

    public Set<HtmlElement> getAllVisibleHtmlElementsBottomUp() {
        return this.visibleHtmlElementsBottomUp;
    }

    public boolean isVisible(HtmlElement anHtmlElement) {
        return this.visibleHtmlElements.contains(anHtmlElement);
    }

    public int getIndex(HtmlElement anHtmlElement) {
        int tmpResult = this.nodes.indexOf(anHtmlElement);
        if (tmpResult < 0) {
            LOG.error("No index found for HtmlElement: " + anHtmlElement.toString());
            this.dumpToLog();
        }
        return tmpResult;
    }

    public FindSpot getPosition(HtmlElement anHtmlElement) {
        FindSpot tmpResult = this.positions.get(anHtmlElement);
        if (null == tmpResult) {
            LOG.error("No position found for HtmlElement: " + anHtmlElement.toString());
            this.dumpToLog();
        }
        return tmpResult;
    }

    public String getHierarchy(HtmlElement anHtmlElement) {
        String tmpResult = this.hierarchies.get(anHtmlElement);
        if (null == tmpResult) {
            LOG.error("No hierarchy found for HtmlElement: " + anHtmlElement.toString());
            this.dumpToLog();
        }
        return tmpResult;
    }

    public FindSpot firstOccurence(SearchPattern aSearchPattern) {
        return aSearchPattern.firstOccurenceIn(this.text.toString(), 0);
    }

    public FindSpot firstOccurence(SearchPattern aSearchPattern, int aStartPos) {
        return aSearchPattern.firstOccurenceIn(this.text.toString(), aStartPos);
    }

    public String getTextBefore(DomNode aDomNode) {
        FindSpot tmpFindSpot = this.positions.get(aDomNode);
        if (null == tmpFindSpot) {
            return null;
        }
        return this.textSubstring(0, tmpFindSpot.getStartPos());
    }

    public String getTextBeforeIncludingMyself(DomNode aDomNode) {
        FindSpot tmpFindSpot = this.positions.get(aDomNode);
        if (null == tmpFindSpot) {
            return null;
        }
        return this.textSubstring(0, tmpFindSpot.getEndPos());
    }

    public String getLabelingTextBefore(HtmlElement anHtmlElement, int aStartPos) {
        FindSpot tmpFindSpot = this.positions.get(anHtmlElement);
        if (null == tmpFindSpot) {
            return null;
        }
        HtmlForm tmpCurrentForm = anHtmlElement.getEnclosingForm();
        int tmpStartPos = 0;
        ListIterator<DomNode> tmpIter = this.nodes.listIterator(this.nodes.indexOf(anHtmlElement));
        while (tmpIter.hasPrevious()) {
            HtmlForm tmpForm;
            String tmpText;
            DomNode tmpNode = tmpIter.previous();
            if (tmpNode instanceof HtmlBody) {
                tmpStartPos = this.positions.get(tmpNode).getStartPos();
                break;
            }
            if (tmpNode instanceof SubmittableElement && !(tmpNode instanceof HtmlHiddenInput) && (tmpStartPos = this.positions.get(tmpNode).getEndPos()) <= tmpFindSpot.getStartPos() && StringUtils.isNotEmpty((CharSequence)(tmpText = this.textSubstring(Math.max(tmpStartPos, aStartPos), tmpFindSpot.getStartPos())))) {
                return tmpText;
            }
            if (!(tmpNode instanceof HtmlElement) || null == (tmpForm = ((HtmlElement)tmpNode).getEnclosingForm()) || tmpForm == tmpCurrentForm) continue;
            tmpStartPos = this.positions.get(tmpNode).getEndPos();
            break;
        }
        return this.textSubstring(Math.max(tmpStartPos, aStartPos), tmpFindSpot.getStartPos());
    }

    public String getLabelingTextAfter(HtmlElement anHtmlElement) {
        FindSpot tmpFindSpot = this.positions.get(anHtmlElement);
        if (null == tmpFindSpot) {
            return null;
        }
        HtmlForm tmpCurrentForm = anHtmlElement.getEnclosingForm();
        int tmpEndPos = this.text.length();
        ListIterator<DomNode> tmpIter = this.nodes.listIterator(this.nodes.indexOf(anHtmlElement));
        tmpIter.next();
        while (tmpIter.hasNext()) {
            DomNode tmpNode = tmpIter.next();
            if (tmpNode instanceof SubmittableElement && !(tmpNode instanceof HtmlHiddenInput)) {
                tmpEndPos = this.positions.get(tmpNode).getStartPos();
                break;
            }
            if (!(tmpNode instanceof HtmlElement)) continue;
            HtmlForm tmpForm = ((HtmlElement)tmpNode).getEnclosingForm();
            if (null == tmpCurrentForm || tmpForm == tmpCurrentForm) continue;
            tmpEndPos = this.positions.get(tmpNode).getStartPos();
            break;
        }
        return this.textSubstring(tmpFindSpot.getEndPos(), tmpEndPos);
    }

    public String getAsText(DomNode aDomNode) {
        FindSpot tmpFindSpot = this.positions.get(aDomNode);
        if (null == tmpFindSpot) {
            return null;
        }
        return this.textSubstring(tmpFindSpot.getStartPos(), tmpFindSpot.getEndPos());
    }

    public String getAsTextWithoutFormControls(DomNode aDomNode) {
        FindSpot tmpFindSpot = this.positionsWithoutFormControls.get(aDomNode);
        if (null == tmpFindSpot) {
            return null;
        }
        return this.textWithoutFormControls.substring(tmpFindSpot.getStartPos(), tmpFindSpot.getEndPos());
    }

    public boolean hasMouseActionListener(MouseAction aMouseAction, HtmlElement anHtmlElement) {
        return this.htmlElementsWithMouseActionListener.get((Object)aMouseAction).contains(anHtmlElement);
    }

    private void parseDomNode(DomNode aDomNode, String aParentHierarchy, Set<MouseAction> aParentMouseActions) {
        if (null == aDomNode) {
            return;
        }
        this.nodes.add(aDomNode);
        FindSpot tmpFindSpot = new FindSpot();
        tmpFindSpot.setStartPos(this.text.length());
        this.positions.put(aDomNode, tmpFindSpot);
        FindSpot tmpFindSpotWFC = new FindSpot();
        tmpFindSpotWFC.setStartPos(this.textWithoutFormControls.length());
        this.positionsWithoutFormControls.put(aDomNode, tmpFindSpotWFC);
        String tmpHierarchy = aParentHierarchy == null ? String.valueOf(this.nodes.indexOf(aDomNode)) : aParentHierarchy + HIERARCHY_DELIMITER + this.nodes.indexOf(aDomNode);
        this.hierarchies.put(aDomNode, tmpHierarchy);
        Set<MouseAction> tmpMouseActions = aParentMouseActions;
        if (this.isDisplayed(aDomNode)) {
            boolean tmpIsHtmlElement = aDomNode instanceof HtmlElement;
            if (tmpIsHtmlElement) {
                HtmlElement tmpHtmlElement = (HtmlElement)aDomNode;
                this.visibleHtmlElements.add(tmpHtmlElement);
                if (!(tmpHtmlElement instanceof HtmlHtml) && !(tmpHtmlElement instanceof HtmlBody)) {
                    tmpMouseActions = this.getAvailableMouseActions(tmpHtmlElement, tmpMouseActions);
                    tmpMouseActions.forEach(a -> this.htmlElementsWithMouseActionListener.get(a).add(tmpHtmlElement));
                }
            }
            if (!(aDomNode instanceof HtmlHiddenInput || aDomNode instanceof HtmlApplet || aDomNode instanceof HtmlScript || aDomNode instanceof HtmlStyle || aDomNode instanceof HtmlFileInput || aDomNode instanceof DomComment || aDomNode instanceof HtmlHead || aDomNode instanceof HtmlTitle)) {
                if (aDomNode instanceof DomText) {
                    this.appendDomText((DomText)aDomNode);
                } else if (aDomNode instanceof HtmlBreak) {
                    this.text.appendBlank();
                    this.textWithoutFormControls.appendBlank();
                } else if (aDomNode instanceof HtmlButtonInput) {
                    this.appendHtmlButtonInput((HtmlButtonInput)aDomNode);
                } else if (aDomNode instanceof HtmlCheckBoxInput) {
                    this.appendHtmlCheckBoxInput((HtmlCheckBoxInput)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlImageInput) {
                    this.appendHtmlImageInput((HtmlImageInput)aDomNode);
                } else if (aDomNode instanceof HtmlRadioButtonInput) {
                    this.appendHtmlRadioButtonInput((HtmlRadioButtonInput)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlResetInput) {
                    this.appendHtmlResetInput((HtmlResetInput)aDomNode);
                } else if (aDomNode instanceof HtmlSubmitInput) {
                    this.appendHtmlSubmitInput((HtmlSubmitInput)aDomNode);
                } else if (aDomNode instanceof HtmlInput) {
                    this.appendHtmlInput((HtmlInput)aDomNode);
                } else if (aDomNode instanceof HtmlButton) {
                    this.appendHtmlButton((HtmlButton)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlFrame) {
                    this.appendHtmlFrame((HtmlFrame)aDomNode, tmpHierarchy);
                } else if (aDomNode instanceof HtmlImage) {
                    this.appendHtmlImage((HtmlImage)aDomNode);
                } else if (aDomNode instanceof HtmlInlineFrame) {
                    this.appendHtmlInlineFrame((HtmlInlineFrame)aDomNode, tmpHierarchy);
                } else if (aDomNode instanceof HtmlInlineQuotation) {
                    this.appendHtmlInlineQuotation((HtmlInlineQuotation)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlLabel) {
                    this.appendHtmlLabel((HtmlLabel)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlLegend) {
                    this.appendHtmlLegend((HtmlLegend)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlObject) {
                    this.appendHtmlObject((HtmlObject)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlOptionGroup) {
                    this.appendHtmlOptionGroup((HtmlOptionGroup)aDomNode);
                } else if (aDomNode instanceof HtmlOrderedList) {
                    this.appendHtmlOrderedList((HtmlOrderedList)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlSelect) {
                    this.appendHtmlSelect((HtmlSelect)aDomNode, tmpHierarchy, tmpMouseActions);
                } else if (aDomNode instanceof HtmlTextArea) {
                    this.appendHtmlTextArea((HtmlTextArea)aDomNode, tmpHierarchy, tmpMouseActions);
                } else {
                    boolean tmpIsBlock;
                    if (aDomNode instanceof HtmlAnchor && DomElement.ATTRIBUTE_NOT_DEFINED != ((HtmlAnchor)aDomNode).getHrefAttribute() && !tmpMouseActions.contains((Object)MouseAction.CLICK)) {
                        tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK);
                    }
                    if (tmpIsBlock = HtmlElementUtil.isBlock(aDomNode)) {
                        this.text.appendBlank();
                        this.textWithoutFormControls.appendBlank();
                    }
                    this.parseChildren(aDomNode, tmpHierarchy, tmpMouseActions);
                    if (tmpIsBlock) {
                        this.text.appendBlank();
                        this.textWithoutFormControls.appendBlank();
                    }
                }
            }
            if (tmpIsHtmlElement) {
                this.visibleHtmlElementsBottomUp.add((HtmlElement)aDomNode);
            }
        }
        tmpFindSpot = this.positions.get(aDomNode);
        tmpFindSpot.setEndPos(this.text.length());
        tmpFindSpotWFC = this.positionsWithoutFormControls.get(aDomNode);
        tmpFindSpotWFC.setEndPos(this.textWithoutFormControls.length());
    }

    private boolean isDisplayed(DomNode aDomNode) {
        String tmpClip;
        HTMLElement tmpHtmlElement;
        CSS2Properties tmpStyle;
        String tmpPosition;
        ScriptableObject tmpScriptableObject;
        if (!aDomNode.isDisplayed()) {
            return false;
        }
        return !(aDomNode instanceof HtmlSpan) || !((tmpScriptableObject = (ScriptableObject)((HtmlElement)aDomNode).getScriptableObject()) instanceof HTMLElement) || !"absolute".equalsIgnoreCase(tmpPosition = (tmpStyle = (tmpHtmlElement = (HTMLElement)tmpScriptableObject).getWindow().getComputedStyle((Object)tmpHtmlElement, null)).getStyleAttribute(StyleAttributes.Definition.POSITION)) || !"rect(0px, 0px, 1px, 1px)".equals(tmpClip = tmpStyle.getStyleAttribute(StyleAttributes.Definition.CLIP));
    }

    private Set<MouseAction> getAvailableMouseActions(HtmlElement aHtmlElement, Set<MouseAction> aParentMouseActions) {
        Set<MouseAction> tmpMouseActions = aParentMouseActions;
        if (!aParentMouseActions.containsAll(EnumSet.of(MouseAction.CLICK, MouseAction.CLICK_DOUBLE, MouseAction.CLICK_RIGHT)) && (aHtmlElement.hasEventHandlers(EVENT_NAME_MOUSE_DOWN) || aHtmlElement.hasEventHandlers(EVENT_NAME_MOUSE_UP))) {
            tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK, MouseAction.CLICK_DOUBLE, MouseAction.CLICK_RIGHT);
        } else {
            if (!aParentMouseActions.containsAll(EnumSet.of(MouseAction.CLICK, MouseAction.CLICK_DOUBLE)) && aHtmlElement.hasEventHandlers(EVENT_NAME_CLICK)) {
                tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK, MouseAction.CLICK_DOUBLE);
            } else if (!aParentMouseActions.contains((Object)MouseAction.CLICK_DOUBLE) && aHtmlElement.hasEventHandlers(EVENT_NAME_DBL_CLICK)) {
                tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK_DOUBLE);
            }
            if (!aParentMouseActions.contains((Object)MouseAction.CLICK_RIGHT) && aHtmlElement.hasEventHandlers(EVENT_NAME_CONTEXT_MENU)) {
                tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK_RIGHT);
            }
        }
        if (!aParentMouseActions.contains((Object)MouseAction.MOUSE_OVER) && (aHtmlElement.hasEventHandlers(EVENT_NAME_MOUSE_OVER) || aHtmlElement.hasEventHandlers(EVENT_NAME_MOUSE_MOVE) || aHtmlElement.hasEventHandlers(EVENT_NAME_MOUSE_OUT))) {
            tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.MOUSE_OVER);
        }
        return tmpMouseActions;
    }

    private Set<MouseAction> copyAndAdd(Set<MouseAction> aCurrentMouseActions, MouseAction ... aNewMouseActions) {
        EnumSet<MouseAction> tmpMouseActions = EnumSet.copyOf(aCurrentMouseActions);
        for (MouseAction tmpNewMouseAction : aNewMouseActions) {
            tmpMouseActions.add(tmpNewMouseAction);
        }
        return tmpMouseActions;
    }

    private void parseChildren(DomNode aNode, String aHierarchy, Set<MouseAction> aMouseActions) {
        for (DomNode tmpChild : aNode.getChildren()) {
            this.parseDomNode(tmpChild, aHierarchy, aMouseActions);
        }
    }

    private void appendDomText(DomText aDomText) {
        ComputedCSSStyleDeclaration tmpStyle;
        HtmlElement tmpParentHtmlElement;
        ScriptableObject tmpScriptableObject;
        DomNode tmpParent;
        String tmpTxt = aDomText.getData();
        for (tmpParent = aDomText.getParentNode(); tmpParent != null && !(tmpParent instanceof HtmlElement); tmpParent = tmpParent.getParentNode()) {
        }
        if (tmpParent != null && (tmpScriptableObject = (ScriptableObject)(tmpParentHtmlElement = (HtmlElement)tmpParent).getScriptableObject()) instanceof HTMLElement && (tmpStyle = ((HTMLElement)tmpScriptableObject).getCurrentStyle()) != null) {
            String tmpTransform = tmpStyle.getStyleAttribute(StyleAttributes.Definition.TEXT_TRANSFORM);
            if ("uppercase".equalsIgnoreCase(tmpTransform)) {
                tmpTxt = tmpTxt.toUpperCase(Locale.ROOT);
            } else if ("lowercase".equalsIgnoreCase(tmpTransform)) {
                tmpTxt = tmpTxt.toLowerCase(Locale.ROOT);
            } else if ("capitalize".equalsIgnoreCase(tmpTransform)) {
                tmpTxt = WordUtils.capitalize((String)tmpTxt);
            }
        }
        this.text.append(tmpTxt);
        this.textWithoutFormControls.append(tmpTxt);
    }

    private void appendHtmlButton(HtmlButton anHtmlButton, String aHierarchy, Set<MouseAction> aMouseActions) {
        Set<MouseAction> tmpMouseActions = aMouseActions;
        if (!tmpMouseActions.contains((Object)MouseAction.CLICK)) {
            tmpMouseActions = this.copyAndAdd(tmpMouseActions, MouseAction.CLICK);
        }
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.textWithoutFormControls.disableAppend();
        this.parseChildren((DomNode)anHtmlButton, aHierarchy, tmpMouseActions);
        this.textWithoutFormControls.enableAppend();
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlButtonInput(HtmlButtonInput anHtmlButtonInput) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.text.append(anHtmlButtonInput.getValueAttribute());
        this.text.appendBlank();
    }

    private void appendHtmlCheckBoxInput(HtmlCheckBoxInput anHtmlCheckBoxInput, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.textWithoutFormControls.disableAppend();
        this.parseChildren((DomNode)anHtmlCheckBoxInput, aHierarchy, aMouseActions);
        this.textWithoutFormControls.enableAppend();
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlFrame(HtmlFrame anHtmlFrame, String aHierarchy) {
        Page tmpPage = anHtmlFrame.getEnclosedPage();
        if (tmpPage instanceof HtmlPage) {
            this.parseDomNode((DomNode)((HtmlPage)tmpPage), aHierarchy, EnumSet.noneOf(MouseAction.class));
        }
    }

    private void appendHtmlImage(HtmlImage anHtmlImage) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.text.append(anHtmlImage.getAltAttribute());
        this.text.appendBlank();
        this.textWithoutFormControls.append(anHtmlImage.getAltAttribute());
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlImageInput(HtmlImageInput anHtmlImageInput) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.text.append(anHtmlImageInput.getAltAttribute());
        this.text.appendBlank();
    }

    private void appendHtmlInlineFrame(HtmlInlineFrame anHtmlInlineFrame, String aHierarchy) {
        Page tmpPage = anHtmlInlineFrame.getEnclosedPage();
        if (tmpPage instanceof HtmlPage) {
            this.parseDomNode((DomNode)((HtmlPage)tmpPage), aHierarchy, EnumSet.noneOf(MouseAction.class));
        }
    }

    private void appendHtmlInlineQuotation(HtmlInlineQuotation anHtmlInlineQuotation, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.text.append("\"");
        this.textWithoutFormControls.append("\"");
        this.parseChildren((DomNode)anHtmlInlineQuotation, aHierarchy, aMouseActions);
        this.text.append("\"");
        this.textWithoutFormControls.append("\"");
    }

    private void appendHtmlInput(HtmlInput anHtmlInput) {
        String tmpValue = anHtmlInput.getValueAttribute();
        if (StringUtils.isEmpty((CharSequence)tmpValue)) {
            tmpValue = anHtmlInput.getPlaceholder();
        }
        this.text.append(tmpValue);
    }

    private void appendHtmlLabel(HtmlLabel anHtmlLabel, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.parseChildren((DomNode)anHtmlLabel, aHierarchy, aMouseActions);
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlLegend(HtmlLegend anHtmlLegend, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.parseChildren((DomNode)anHtmlLegend, aHierarchy, aMouseActions);
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlObject(HtmlObject anHtmlObject, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.text.append(" ");
        this.textWithoutFormControls.append(" ");
        HTMLObjectElement tmpJsObject = (HTMLObjectElement)anHtmlObject.getScriptableObject();
        if (null == tmpJsObject || null == tmpJsObject.unwrap()) {
            this.parseChildren((DomNode)anHtmlObject, aHierarchy, aMouseActions);
        }
        this.text.append(" ");
        this.textWithoutFormControls.append(" ");
    }

    private void appendHtmlOptionGroup(HtmlOptionGroup anHtmlOptionGroup) {
        String tmpLabel = anHtmlOptionGroup.getLabelAttribute();
        this.text.append(tmpLabel);
    }

    private void appendHtmlOrderedList(HtmlOrderedList anHtmlOrderedList, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        int i = 1;
        for (DomNode tmpItem : anHtmlOrderedList.getChildren()) {
            if (tmpItem instanceof HtmlListItem) {
                int tmpStartPos = this.text.length();
                this.text.append(String.valueOf(i));
                this.text.append(". ");
                int tmpStartPosWFC = this.textWithoutFormControls.length();
                this.textWithoutFormControls.append(String.valueOf(i++));
                this.textWithoutFormControls.append(". ");
                this.parseDomNode(tmpItem, aHierarchy, aMouseActions);
                FindSpot tmpFindSpot = this.positions.get(tmpItem);
                tmpFindSpot.setStartPos(tmpStartPos);
                FindSpot tmpFindSpotWFC = this.positionsWithoutFormControls.get(tmpItem);
                tmpFindSpotWFC.setStartPos(tmpStartPosWFC);
                continue;
            }
            this.parseDomNode(tmpItem, aHierarchy, aMouseActions);
        }
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlRadioButtonInput(HtmlRadioButtonInput anHtmlRadioButtonInput, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.textWithoutFormControls.disableAppend();
        this.parseChildren((DomNode)anHtmlRadioButtonInput, aHierarchy, aMouseActions);
        this.textWithoutFormControls.enableAppend();
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlResetInput(HtmlResetInput anHtmlResetInput) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.text.append(anHtmlResetInput.getValueAttribute());
        this.text.appendBlank();
    }

    private void appendHtmlSelect(HtmlSelect anHtmlSelect, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.textWithoutFormControls.disableAppend();
        for (DomNode tmpItem : anHtmlSelect.getHtmlElementDescendants()) {
            if (!(tmpItem instanceof HtmlOption) && !(tmpItem instanceof HtmlOptionGroup)) continue;
            this.text.appendBlank();
            this.textWithoutFormControls.appendBlank();
            this.parseDomNode(tmpItem, aHierarchy, aMouseActions);
        }
        this.textWithoutFormControls.enableAppend();
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
    }

    private void appendHtmlSubmitInput(HtmlSubmitInput anHtmlSubmitInput) {
        this.text.appendBlank();
        this.textWithoutFormControls.appendBlank();
        this.text.append(anHtmlSubmitInput.getValueAttribute());
        this.text.appendBlank();
    }

    private void appendHtmlTextArea(HtmlTextArea anHtmlTextArea, String aHierarchy, Set<MouseAction> aMouseActions) {
        this.textWithoutFormControls.disableAppend();
        int tmpOldLength = this.text.length();
        this.parseChildren((DomNode)anHtmlTextArea, aHierarchy, aMouseActions);
        if (this.text.length() == tmpOldLength) {
            this.text.append(anHtmlTextArea.getPlaceholder());
        }
        this.textWithoutFormControls.enableAppend();
    }

    private String textSubstring(int aStartPos, int anEndPos) {
        try {
            return this.text.substring(aStartPos, anEndPos);
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error("Invalid position(s) provided for text.substring(); startPos: " + aStartPos + " endPos: " + anEndPos);
            this.dumpToLog();
            throw e;
        }
    }

    public void dumpToLog() {
        StringBuilder tmpLog = new StringBuilder(400).append("\n ---- HtmlPageIndex dump -------------------------------------------------------\n text                   : ").append(this.text).append('\n');
        for (DomNode tmpDomNode : this.nodes) {
            FindSpot tmpPos = this.positions.get(tmpDomNode);
            tmpLog.append("  ").append(tmpDomNode.getNodeName()).append("  [").append(Integer.toString(tmpPos.getStartPos())).append(", ").append(Integer.toString(tmpPos.getEndPos())).append("]  ").append(tmpDomNode.getClass().getName());
            String tmpValue = tmpDomNode.getNodeValue();
            if (null != tmpValue) {
                tmpLog.append("  '").append(tmpValue).append('\'');
            }
            tmpLog.append('\n');
        }
        tmpLog.append(" ---- end HtmlPageIndex dump ---------------------------------------------------\n");
        LOG.error(tmpLog.toString());
    }
}

