/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmailInput;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.HtmlUrlInput;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.wetator.backend.htmlunit.util.DescribingTextBuilder;

public final class HtmlElementUtil {
    private HtmlElementUtil() {
    }

    public static String getDescribingTextForHtmlAnchor(HtmlAnchor anHtmlAnchor) {
        String tmpText;
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlAnchor);
        if (anHtmlAnchor.getFirstChild() instanceof HtmlImage) {
            tmpBuilder.addPlain("'image: " + ((HtmlImage)anHtmlAnchor.getFirstChild()).getSrcAttribute() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpText = anHtmlAnchor.asNormalizedText()))) {
            tmpBuilder.addText(tmpText);
        }
        return tmpBuilder.addId().addName().build();
    }

    public static String getDescribingTextForHtmlBody(HtmlBody anHtmlBody) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlBody).build();
    }

    public static String getDescribingTextForHtmlButton(HtmlButton anHtmlButton) {
        String tmpText;
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlButton);
        if (anHtmlButton.getFirstChild() instanceof HtmlImage) {
            tmpBuilder.addPlain("'image: " + ((HtmlImage)anHtmlButton.getFirstChild()).getSrcAttribute() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpText = anHtmlButton.asNormalizedText()))) {
            tmpBuilder.addText(tmpText);
        } else if (StringUtils.isNotEmpty((CharSequence)anHtmlButton.getValueAttribute())) {
            tmpBuilder.addText(anHtmlButton.getValueAttribute());
        }
        return tmpBuilder.addId().addName().build();
    }

    public static String getDescribingTextForHtmlButtonInput(HtmlButtonInput anHtmlButtonInput) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlButtonInput).addText(anHtmlButtonInput.getValueAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlCheckBoxInput(HtmlCheckBoxInput anHtmlCheckBoxInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlCheckBoxInput).build();
    }

    public static String getDescribingTextForHtmlFileInput(HtmlFileInput anHtmlFileInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlFileInput).build();
    }

    public static String getDescribingTextForHtmlHiddenInput(HtmlHiddenInput anHtmlHiddenInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlHiddenInput).build();
    }

    public static String getDescribingTextForHtmlImage(HtmlImage anHtmlImage) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlImage).addText(anHtmlImage.getSrcAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlImageInput(HtmlImageInput anHtmlImageInput) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlImageInput).addText(anHtmlImageInput.getValueAttribute()).addAttribute("src", anHtmlImageInput.getSrcAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlLabel(HtmlLabel anHtmlLabel) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlLabel);
        String tmpText = anHtmlLabel.asNormalizedText();
        if (StringUtils.isNotEmpty((CharSequence)tmpText)) {
            tmpBuilder.addText(tmpText);
        }
        tmpBuilder.addId().addName();
        String tmpFor = anHtmlLabel.getForAttribute();
        if (StringUtils.isNotEmpty((CharSequence)tmpFor)) {
            tmpBuilder.addAttribute("for", tmpFor);
        }
        return tmpBuilder.build();
    }

    public static String getDescribingTextForHtmlParagraph(HtmlParagraph anHtmlParagraph) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlParagraph);
        String tmpText = anHtmlParagraph.asNormalizedText();
        if (StringUtils.isNotEmpty((CharSequence)tmpText)) {
            tmpBuilder.addText(tmpText);
        }
        return tmpBuilder.addId().addName().build();
    }

    public static String getDescribingTextForHtmlPasswordInput(HtmlPasswordInput anHtmlPasswordInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlPasswordInput).build();
    }

    public static String getDescribingTextForHtmlRadioButtonInput(HtmlRadioButtonInput anHtmlRadioButtonInput) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlRadioButtonInput).addText(anHtmlRadioButtonInput.getValueAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlResetInput(HtmlResetInput anHtmlResetInput) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlResetInput).addText(anHtmlResetInput.getValueAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlSelect(HtmlSelect anHtmlSelect) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlSelect).build();
    }

    public static String getDescribingTextForHtmlSpan(HtmlSpan anHtmlSpan) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlSpan).addText(anHtmlSpan.asNormalizedText()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlSubmitInput(HtmlSubmitInput anHtmlSubmitInput) {
        return DescribingTextBuilder.createCustom((HtmlElement)anHtmlSubmitInput).addText(anHtmlSubmitInput.getValueAttribute()).addId().addName().build();
    }

    public static String getDescribingTextForHtmlTextArea(HtmlTextArea anHtmlTextArea) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlTextArea).build();
    }

    public static String getDescribingTextForHtmlEmailInput(HtmlEmailInput anHtmlEmailInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlEmailInput).build();
    }

    public static String getDescribingTextForHtmlUrlInput(HtmlUrlInput anHtmlUrlInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlUrlInput).build();
    }

    public static String getDescribingTextForHtmlTextInput(HtmlTextInput anHtmlTextInput) {
        return DescribingTextBuilder.createDefault((HtmlElement)anHtmlTextInput).build();
    }

    public static String getDescribingTextForHtmlOption(HtmlOption anHtmlOption) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlOption).addText(anHtmlOption.asNormalizedText()).addId().addName();
        HtmlSelect tmpSelect = anHtmlOption.getEnclosingSelect();
        if (null != tmpSelect) {
            tmpBuilder.addPlain("part of " + HtmlElementUtil.getDescribingTextForHtmlSelect(tmpSelect));
        }
        return tmpBuilder.build();
    }

    public static String getDescribingTextForHtmlOptionGroup(HtmlOptionGroup anHtmlOptionGroup) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom((HtmlElement)anHtmlOptionGroup).addText(anHtmlOptionGroup.getLabelAttribute()).addId().addName();
        HtmlSelect tmpSelect = anHtmlOptionGroup.getEnclosingSelect();
        if (null != tmpSelect) {
            tmpBuilder.addPlain("part of " + HtmlElementUtil.getDescribingTextForHtmlSelect(tmpSelect));
        }
        return tmpBuilder.build();
    }

    public static boolean isBlock(DomNode aDomNode) {
        SgmlPage tmpPage = aDomNode.getPage();
        if (tmpPage instanceof HtmlPage && tmpPage.getEnclosingWindow().getWebClient().getOptions().isCssEnabled()) {
            ScriptableObject tmpScriptableObject = null;
            int i = 0;
            while (tmpScriptableObject == null) {
                try {
                    tmpScriptableObject = (ScriptableObject)aDomNode.getScriptableObject();
                }
                catch (IllegalStateException e) {
                    if (i > 1) {
                        throw e;
                    }
                    try {
                        Thread.sleep(42L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (tmpScriptableObject instanceof HTMLElement) {
                HTMLElement tmpElement = (HTMLElement)tmpScriptableObject;
                ComputedCSSStyleDeclaration tmpStyle = tmpElement.getCurrentStyle();
                if (tmpStyle != null) {
                    String tmpDisplay = tmpStyle.getDisplay();
                    if ("block".equals(tmpDisplay) || "inline-block".equals(tmpDisplay) || "list-item".equals(tmpDisplay) || "flex".equals(tmpDisplay)) {
                        return true;
                    }
                    if (tmpDisplay != null && (tmpDisplay.startsWith("table") || "inline-table".equals(tmpDisplay))) {
                        return true;
                    }
                }
                if (tmpElement instanceof HTMLLinkElement) {
                    return true;
                }
                if (tmpElement instanceof HTMLOptionElement) {
                    return true;
                }
            }
        }
        return false;
    }
}

