/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wetator.backend.IBrowser;

public final class ContentTypeUtil {
    private static final Map<String, IBrowser.ContentType> CONTENT_TYPES = new HashMap<String, IBrowser.ContentType>();
    private static final EnumMap<IBrowser.ContentType, String> FILE_EXTENSIONS = new EnumMap(IBrowser.ContentType.class);

    private static void define(IBrowser.ContentType aContentType, String aFileExtension, String ... aContentTypeStrings) {
        FILE_EXTENSIONS.put(aContentType, aFileExtension);
        for (String tmpContentType : aContentTypeStrings) {
            CONTENT_TYPES.put(tmpContentType.toLowerCase(Locale.ROOT), aContentType);
        }
    }

    private ContentTypeUtil() {
    }

    public static IBrowser.ContentType getContentType(Page aPage) {
        if (aPage == null) {
            return IBrowser.ContentType.OTHER;
        }
        if (aPage instanceof HtmlPage) {
            return IBrowser.ContentType.HTML;
        }
        if (aPage instanceof TextPage) {
            return IBrowser.ContentType.TEXT;
        }
        return ContentTypeUtil.getContentType(aPage.getWebResponse());
    }

    private static IBrowser.ContentType getContentType(WebResponse aWebResponse) {
        if (null == aWebResponse) {
            return IBrowser.ContentType.OTHER;
        }
        String tmpContentTypeString = aWebResponse.getContentType();
        IBrowser.ContentType tmpContentType = CONTENT_TYPES.get(tmpContentTypeString.toLowerCase(Locale.ROOT));
        if (null == tmpContentType) {
            return IBrowser.ContentType.OTHER;
        }
        return tmpContentType;
    }

    public static String getFileSuffix(Page aPage) {
        IBrowser.ContentType tmpContentType = ContentTypeUtil.getContentType(aPage);
        if (aPage != null) {
            return ContentTypeUtil.getFileSuffix(tmpContentType, aPage.getWebResponse());
        }
        return ContentTypeUtil.getFileSuffix(tmpContentType, null);
    }

    public static String getFileSuffix(WebResponse aWebResponse) {
        IBrowser.ContentType tmpContentType = ContentTypeUtil.getContentType(aWebResponse);
        return ContentTypeUtil.getFileSuffix(tmpContentType, aWebResponse);
    }

    private static String getFileSuffix(IBrowser.ContentType aContentType, WebResponse aWebResponse) {
        String tmpResult = FILE_EXTENSIONS.get((Object)aContentType);
        if (null == tmpResult) {
            int tmpDotPos;
            String tmpFileName = ContentTypeUtil.getSuggestedFilename(aWebResponse);
            if (StringUtils.isNotBlank((CharSequence)tmpFileName) && (tmpDotPos = (tmpFileName = tmpFileName.trim()).lastIndexOf(46)) > -1 && tmpDotPos < tmpFileName.length() - 1) {
                tmpFileName = tmpFileName.substring(tmpDotPos + 1);
                return tmpFileName;
            }
            return "bin";
        }
        return tmpResult;
    }

    private static String getSuggestedFilename(WebResponse aWebResponse) {
        if (aWebResponse == null) {
            return null;
        }
        String tmpDisposition = aWebResponse.getResponseHeaderValue("Content-Disposition");
        if (StringUtils.isBlank((CharSequence)tmpDisposition)) {
            return null;
        }
        int tmpStart = tmpDisposition.indexOf("filename=");
        if (tmpStart == -1) {
            return null;
        }
        if ((tmpStart += "filename=".length()) >= tmpDisposition.length()) {
            return null;
        }
        int tmpEnd = tmpDisposition.indexOf(59, tmpStart);
        if (tmpEnd == -1) {
            tmpEnd = tmpDisposition.length();
        }
        if (tmpDisposition.charAt(tmpStart) == '\"' && tmpDisposition.charAt(tmpEnd - 1) == '\"') {
            ++tmpStart;
            --tmpEnd;
        }
        return tmpDisposition.substring(tmpStart, tmpEnd);
    }

    public static IBrowser.ContentType getContentTypeForFileName(String aFileName) {
        if (null == aFileName) {
            return IBrowser.ContentType.OTHER;
        }
        for (Map.Entry<IBrowser.ContentType, String> tmpEntry : FILE_EXTENSIONS.entrySet()) {
            if (!aFileName.toLowerCase(Locale.ROOT).endsWith(tmpEntry.getValue())) continue;
            return tmpEntry.getKey();
        }
        return IBrowser.ContentType.OTHER;
    }

    static {
        ContentTypeUtil.define(IBrowser.ContentType.HTML, "html", "text/html");
        ContentTypeUtil.define(IBrowser.ContentType.CSS, "css", "text/css");
        ContentTypeUtil.define(IBrowser.ContentType.JAVASCRIPT, "js", "text/javascript", "application/x-javascript");
        ContentTypeUtil.define(IBrowser.ContentType.TEXT, "txt", "text/plain");
        ContentTypeUtil.define(IBrowser.ContentType.XML, "xml", "text/xml");
        ContentTypeUtil.define(IBrowser.ContentType.PDF, "pdf", "application/pdf");
        ContentTypeUtil.define(IBrowser.ContentType.TEXT, "csv", "text/csv");
        ContentTypeUtil.define(IBrowser.ContentType.XLS, "xls", "application/vnd.ms-excel");
        ContentTypeUtil.define(IBrowser.ContentType.XLSX, "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        ContentTypeUtil.define(IBrowser.ContentType.DOC, "doc", "application/msword");
        ContentTypeUtil.define(IBrowser.ContentType.DOCX, "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        ContentTypeUtil.define(IBrowser.ContentType.RTF, "rtf", "application/rtf", "text/rtf", "text/richtext", "text/enriched");
        ContentTypeUtil.define(IBrowser.ContentType.PNG, "png", "image/png");
        ContentTypeUtil.define(IBrowser.ContentType.GIF, "gif", "image/gif");
        ContentTypeUtil.define(IBrowser.ContentType.BMP, "bmp", "image/bmp");
        ContentTypeUtil.define(IBrowser.ContentType.JPEG, "jpeg", "image/jpeg");
        ContentTypeUtil.define(IBrowser.ContentType.SVG, "svg", "image/svg+xml");
        ContentTypeUtil.define(IBrowser.ContentType.ZIP, "zip", "application/zip");
    }
}

