/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;

public class HtmlUnitUnspecificControl<T extends HtmlElement>
extends HtmlUnitBaseControl<HtmlElement> {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitUnspecificControl.class);

    public HtmlUnitUnspecificControl(T anHtmlElement) {
        super(anHtmlElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("HtmlUnitUnspecificControl for " + anHtmlElement + " created.");
        }
    }

    @Override
    public String getDescribingText() {
        Object tmpHtmlElement = this.getHtmlElement();
        if (tmpHtmlElement instanceof HtmlBody) {
            return HtmlElementUtil.getDescribingTextForHtmlBody((HtmlBody)tmpHtmlElement);
        }
        if (tmpHtmlElement instanceof HtmlHiddenInput) {
            return HtmlElementUtil.getDescribingTextForHtmlHiddenInput((HtmlHiddenInput)tmpHtmlElement);
        }
        if (tmpHtmlElement instanceof HtmlLabel) {
            return HtmlElementUtil.getDescribingTextForHtmlLabel((HtmlLabel)tmpHtmlElement);
        }
        if (tmpHtmlElement instanceof HtmlParagraph) {
            return HtmlElementUtil.getDescribingTextForHtmlParagraph((HtmlParagraph)tmpHtmlElement);
        }
        if (tmpHtmlElement instanceof HtmlSpan) {
            return HtmlElementUtil.getDescribingTextForHtmlSpan((HtmlSpan)tmpHtmlElement);
        }
        StringBuilder tmpResult = new StringBuilder("[Unknown HtmlElement '").append(tmpHtmlElement.getClass()).append('\'');
        HtmlUnitUnspecificControl.addId(tmpResult, tmpHtmlElement);
        HtmlUnitUnspecificControl.addName(tmpResult, tmpHtmlElement);
        tmpResult.append(']');
        return tmpResult.toString();
    }

    private static void addId(StringBuilder aStringBuilder, HtmlElement anHtmlElement) {
        String tmpId = anHtmlElement.getAttribute("id");
        if (StringUtils.isNotEmpty((CharSequence)tmpId)) {
            aStringBuilder.append(" (id='");
            aStringBuilder.append(tmpId);
            aStringBuilder.append("')");
        }
    }

    private static void addName(StringBuilder aStringBuilder, HtmlElement anHtmlElement) {
        String tmpName = anHtmlElement.getAttribute("name");
        if (StringUtils.isNotEmpty((CharSequence)tmpName)) {
            aStringBuilder.append(" (name='");
            aStringBuilder.append(tmpName);
            aStringBuilder.append("')");
        }
    }
}

