/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.control.IDeselectable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.IHtmlUnitDisableable;
import org.wetator.backend.htmlunit.control.IHtmlUnitFocusable;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitInputCheckBoxIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlCheckBoxInput.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitInputCheckBoxIdentifier.class})
public class HtmlUnitInputCheckBox
extends HtmlUnitBaseControl<HtmlCheckBoxInput>
implements IDeselectable,
IHtmlUnitDisableable<HtmlCheckBoxInput>,
IHtmlUnitFocusable<HtmlCheckBoxInput> {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitInputCheckBox.class);
    private HtmlLabel htmlLabel;

    public HtmlUnitInputCheckBox(HtmlCheckBoxInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        HtmlCheckBoxInput tmpHtmlCheckBoxInput = (HtmlCheckBoxInput)this.getHtmlElement();
        StringBuilder tmpText = new StringBuilder(HtmlElementUtil.getDescribingTextForHtmlCheckBoxInput(tmpHtmlCheckBoxInput));
        if (this.htmlLabel != null) {
            tmpText.append(" by ").append(HtmlElementUtil.getDescribingTextForHtmlLabel(this.htmlLabel));
        }
        return tmpText.toString();
    }

    @Override
    public void select(WetatorContext aWetatorContext) throws ActionException {
        HtmlCheckBoxInput tmpHtmlCheckBoxInput = (HtmlCheckBoxInput)this.getHtmlElement();
        if (tmpHtmlCheckBoxInput.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        if (tmpHtmlCheckBoxInput.isReadOnly()) {
            String tmpMessage = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            if (tmpHtmlCheckBoxInput.isChecked()) {
                aWetatorContext.informListenersWarn("elementAlreadySelected", this.getDescribingText());
            } else if (this.htmlLabel == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select - HtmlUnitInputCheckBox.click() '" + tmpHtmlCheckBoxInput + "'");
                }
                tmpHtmlCheckBoxInput.click();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select - HtmlUnitInputCheckBox.click() '" + this.htmlLabel + "'");
                }
                this.htmlLabel.click();
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public boolean isSelected(WetatorContext aWetatorContext) {
        return ((HtmlCheckBoxInput)this.getHtmlElement()).isChecked();
    }

    @Override
    public void deselect(WetatorContext aWetatorContext) throws ActionException {
        HtmlCheckBoxInput tmpHtmlCheckBoxInput = (HtmlCheckBoxInput)this.getHtmlElement();
        if (tmpHtmlCheckBoxInput.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        if (tmpHtmlCheckBoxInput.isReadOnly()) {
            String tmpMessage = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            if (tmpHtmlCheckBoxInput.isChecked()) {
                if (this.htmlLabel == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deselect - HtmlUnitInputCheckBox.click() '" + tmpHtmlCheckBoxInput + "'");
                    }
                    tmpHtmlCheckBoxInput.click();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deselect - HtmlUnitInputCheckBox.click() '" + this.htmlLabel + "'");
                    }
                    this.htmlLabel.click();
                }
            } else {
                aWetatorContext.informListenersWarn("elementAlreadyDeselected", this.getDescribingText());
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    public void setHtmlLabel(HtmlLabel aHtmlLabel) {
        this.htmlLabel = aHtmlLabel;
    }
}

