/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.htmlunit.XHtmlOutputter;
import org.wetator.backend.htmlunit.util.ContentTypeUtil;
import org.wetator.exception.ResourceException;

public final class ResponseStore {
    private static final Logger LOG = LogManager.getLogger(ResponseStore.class);
    private static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\(\\s*([\"']?)(.*?)([\"']?)\\s*\\)");
    private static final Pattern CSS_IMPORT_URL_PATTERN = Pattern.compile("@import\\s+([\"'])(.*?)([\"'])");
    private static final int MAX_FILE_NAME_LENGTH = 200;
    private static long counter = 99999L;
    private Map<String, String> fileNames;
    private File outputDir;
    private boolean overwrite;
    private WebClient webClient;
    private File storeDir;
    private String relStoreDir;

    private static long getUniqueId() {
        return ++counter;
    }

    public ResponseStore(File anOutputDir, String aBrowserSubdir, boolean anOverwriteFlag) {
        this.outputDir = anOutputDir;
        this.overwrite = anOverwriteFlag;
        this.initOutputDir(aBrowserSubdir);
        this.fileNames = new HashMap<String, String>();
    }

    private void initOutputDir(String aBrowserSubdir) {
        String tmpDirectoryName;
        if (this.overwrite) {
            tmpDirectoryName = "responses_current";
        } else {
            SimpleDateFormat tmpFormater = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.ROOT);
            tmpDirectoryName = "responses_" + tmpFormater.format(new Date());
        }
        this.storeDir = new File(new File(this.outputDir, aBrowserSubdir.toLowerCase(Locale.ROOT)), tmpDirectoryName);
        this.relStoreDir = this.outputDir.toPath().relativize(this.storeDir.toPath()).toString();
        this.relStoreDir = this.relStoreDir.replaceAll("\\\\", "/");
        try {
            FileUtils.forceMkdir((File)this.storeDir);
            FileUtils.cleanDirectory((File)this.storeDir);
        }
        catch (IOException e) {
            LOG.error("IO exception for dir: " + FilenameUtils.normalize((String)this.storeDir.getAbsolutePath()), (Throwable)e);
        }
    }

    public String storeTextContent(String aContent) {
        File tmpFile = null;
        try {
            StringBuilder tmpFileName = new StringBuilder("content_").append(ResponseStore.getUniqueId()).append(".txt");
            tmpFile = new File(this.storeDir, tmpFileName.toString());
            FileUtils.write((File)tmpFile, (CharSequence)aContent, (Charset)StandardCharsets.UTF_8);
            return this.relStoreDir + "/" + tmpFileName;
        }
        catch (IOException e) {
            throw new ResourceException("Could not write file '" + FilenameUtils.normalize((String)tmpFile.getAbsolutePath()) + "'.", e);
        }
    }

    public String storePage(WebClient aWebClient, Page aPage) {
        this.webClient = aWebClient;
        return this.storePage(aPage);
    }

    public String storePage(Page aPage) {
        File tmpFile = null;
        try {
            String tmpSuffix = ContentTypeUtil.getFileSuffix(aPage);
            StringBuilder tmpFileName = new StringBuilder("response_").append(ResponseStore.getUniqueId()).append('.').append(tmpSuffix);
            tmpFile = new File(this.storeDir, tmpFileName.toString());
            if (aPage instanceof HtmlPage) {
                XHtmlOutputter tmpHtmlOutputter = new XHtmlOutputter((HtmlPage)aPage, this);
                tmpHtmlOutputter.writeTo(tmpFile);
            } else {
                WebResponse tmpWebResponse = aPage.getWebResponse();
                try (InputStream tmpIn = tmpWebResponse.getContentAsStream();
                     OutputStream tmpOutputStream = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
                    int tmpBytes;
                    byte[] tmpBuffer = new byte[1024];
                    while ((tmpBytes = tmpIn.read(tmpBuffer)) > 0) {
                        tmpOutputStream.write(tmpBuffer, 0, tmpBytes);
                    }
                }
            }
            return this.relStoreDir + "/" + tmpFileName;
        }
        catch (IOException e) {
            throw new ResourceException("Could not write file '" + FilenameUtils.normalize((String)tmpFile.getAbsolutePath()) + "'.", e);
        }
    }

    public String storeContentFromUrl(URL aBaseUrl, URL aFullContentUrl, HtmlLink aLink, HtmlImage anImage, int aDeep, String aSuffix) {
        try {
            if ("data".equals(aFullContentUrl.getProtocol())) {
                return null;
            }
            String tmpBaseHost = aBaseUrl.getHost();
            if (null == tmpBaseHost || !tmpBaseHost.equals(aFullContentUrl.getHost())) {
                LOG.info("Ignoring URL '" + aFullContentUrl.toExternalForm() + "' (wrong host).");
                return null;
            }
            String tmpFileName = this.fileNames.get(aFullContentUrl.toExternalForm());
            if (null == tmpFileName) {
                String tmpQuery;
                WebResponse tmpWebResponse;
                if (null != aLink) {
                    tmpWebResponse = aLink.getWebResponse(true);
                    if (tmpWebResponse == null) {
                        LOG.warn("Ignoring link '" + aLink.asXml() + "'");
                        return null;
                    }
                } else if (null != anImage) {
                    tmpWebResponse = anImage.getWebResponse(true);
                    if (tmpWebResponse == null) {
                        LOG.warn("Ignoring image '" + anImage.asXml() + "'");
                        return null;
                    }
                } else {
                    WebRequest tmpRequest = new WebRequest(aFullContentUrl);
                    tmpRequest.setAdditionalHeader("Referer", aBaseUrl.toExternalForm());
                    tmpWebResponse = this.webClient.loadWebResponse(tmpRequest);
                    try {
                        this.webClient.throwFailingHttpStatusCodeExceptionIfNecessary(tmpWebResponse);
                    }
                    catch (FailingHttpStatusCodeException e) {
                        LOG.warn("Could not read url '" + aFullContentUrl.toExternalForm() + "'.", (Throwable)e);
                        return null;
                    }
                }
                if ((tmpFileName = aFullContentUrl.getPath()).charAt(0) == '/') {
                    tmpFileName = tmpFileName.substring(1);
                }
                if (null != (tmpQuery = aFullContentUrl.getQuery())) {
                    tmpQuery = URLDecoder.decode(tmpQuery, "UTF-8");
                    tmpFileName = tmpFileName + '?' + tmpQuery;
                }
                tmpFileName = tmpFileName.replaceAll(">", "__");
                tmpFileName = tmpFileName.replaceAll("<", "__");
                tmpFileName = tmpFileName.replaceAll(":", "__");
                tmpFileName = tmpFileName.replaceAll("\"", "__");
                tmpFileName = tmpFileName.replaceAll("\\|", "__");
                tmpFileName = tmpFileName.replaceAll("\\?", "__");
                tmpFileName = tmpFileName.replaceAll("\\*", "__");
                if (null == aSuffix) {
                    String tmpFileSuffix = ContentTypeUtil.getFileSuffix(tmpWebResponse);
                    if (!tmpFileName.endsWith(tmpFileSuffix)) {
                        tmpFileName = tmpFileName + '.' + tmpFileSuffix;
                    }
                } else if (!tmpFileName.endsWith(aSuffix)) {
                    tmpFileName = tmpFileName + aSuffix;
                }
                File tmpResourceFile = new File(this.storeDir, tmpFileName);
                if (tmpResourceFile.getAbsolutePath().length() > 200) {
                    StringBuilder tmpShortFileName = new StringBuilder();
                    tmpShortFileName.append("resource/resource_").append(Long.toString(ResponseStore.getUniqueId()));
                    if (null != aSuffix) {
                        tmpShortFileName.append(aSuffix);
                    } else {
                        tmpShortFileName.append('.').append(ContentTypeUtil.getFileSuffix(tmpWebResponse));
                    }
                    tmpFileName = tmpShortFileName.toString();
                    tmpResourceFile = new File(this.storeDir, tmpFileName);
                }
                this.fileNames.put(aFullContentUrl.toExternalForm(), tmpFileName);
                if (!tmpResourceFile.exists()) {
                    String tmpResponse;
                    String tmpContentType;
                    String tmpProcessed = null;
                    if (null != anImage) {
                        FileUtils.forceMkdir((File)tmpResourceFile.getParentFile());
                        anImage.saveAs(tmpResourceFile);
                    }
                    if ("text/css".equalsIgnoreCase(tmpContentType = tmpWebResponse.getContentType()) && null != (tmpResponse = ResponseStore.getContentAsStringWithoutBOM(tmpWebResponse))) {
                        FileUtils.forceMkdir((File)tmpResourceFile.getParentFile());
                        tmpProcessed = this.processCSS(aFullContentUrl, tmpResponse, StringUtils.countMatches((CharSequence)tmpFileName, (CharSequence)"/"));
                        FileUtils.writeStringToFile((File)tmpResourceFile, (String)tmpProcessed, (Charset)StandardCharsets.UTF_8);
                    }
                    if (tmpProcessed == null) {
                        FileUtils.forceMkdir((File)tmpResourceFile.getParentFile());
                        try (InputStream tmpInStream = tmpWebResponse.getContentAsStream();
                             OutputStream tmpOutStream = Files.newOutputStream(tmpResourceFile.toPath(), new OpenOption[0]);){
                            IOUtils.copy((InputStream)tmpInStream, (OutputStream)tmpOutStream);
                        }
                    }
                }
            }
            StringBuilder tmpResult = new StringBuilder();
            if (aDeep <= 0) {
                tmpResult.append("./");
            } else {
                for (int i = 0; i < aDeep; ++i) {
                    tmpResult.append("../");
                }
            }
            tmpResult.append(tmpFileName);
            return tmpResult.toString();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String processCSS(URL aFullContentUrl, String aCssContent, int aDeep) throws MalformedURLException {
        String tmpReplacement;
        String tmpNewUrl;
        URL tmpCssUrl;
        String tmpContent = aCssContent;
        int tmpStart = 0;
        Matcher tmpMatcher = CSS_URL_PATTERN.matcher(aCssContent);
        while (tmpMatcher.find(tmpStart)) {
            tmpCssUrl = UrlUtils.toUrlUnsafe((String)UrlUtils.resolveUrl((URL)aFullContentUrl, (String)tmpMatcher.group(2)));
            tmpNewUrl = this.storeContentFromUrl(aFullContentUrl, tmpCssUrl, null, null, aDeep, null);
            if (null == tmpNewUrl) {
                tmpStart = tmpMatcher.end();
                continue;
            }
            tmpReplacement = "url(" + tmpMatcher.group(1) + tmpNewUrl + tmpMatcher.group(3) + ")";
            tmpContent = tmpContent.substring(0, tmpMatcher.start()) + tmpReplacement + tmpContent.substring(tmpMatcher.end());
            tmpStart = tmpMatcher.start() + tmpReplacement.length();
            tmpMatcher = CSS_URL_PATTERN.matcher(tmpContent);
        }
        tmpStart = 0;
        tmpMatcher = CSS_IMPORT_URL_PATTERN.matcher(tmpContent);
        while (tmpMatcher.find(tmpStart)) {
            tmpCssUrl = UrlUtils.toUrlUnsafe((String)UrlUtils.resolveUrl((URL)aFullContentUrl, (String)tmpMatcher.group(2)));
            tmpNewUrl = this.storeContentFromUrl(aFullContentUrl, tmpCssUrl, null, null, aDeep, null);
            if (null == tmpNewUrl) {
                tmpStart = tmpMatcher.end();
                continue;
            }
            tmpReplacement = "@import" + tmpMatcher.group(1) + tmpNewUrl + tmpMatcher.group(3);
            tmpContent = tmpContent.substring(0, tmpMatcher.start()) + tmpReplacement + tmpContent.substring(tmpMatcher.end());
            tmpStart = tmpMatcher.start() + tmpReplacement.length();
            tmpMatcher = CSS_IMPORT_URL_PATTERN.matcher(tmpContent);
        }
        return tmpContent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getContentAsStringWithoutBOM(WebResponse aWebResponse) {
        Charset tmpCharset = aWebResponse.getContentCharset();
        try (InputStream tmpIn = aWebResponse.getContentAsStream();){
            if (null == tmpIn) {
                String string2 = null;
                return string2;
            }
            String string = IOUtils.toString((InputStream)tmpIn, (Charset)tmpCharset);
            return string;
        }
        catch (IOException e) {
            LOG.warn("", (Throwable)e);
            return null;
        }
    }
}

