/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Event
extends HtmlUnitScriptable {
    protected static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_POPSTATE = "popstate";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final String TYPE_HASH_CHANGE = "hashchange";
    public static final String TYPE_READY_STATE_CHANGE = "readystatechange";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_CLOSE = "close";
    public static final String TYPE_OPEN = "open";
    public static final String TYPE_LOAD_START = "loadstart";
    public static final String TYPE_LOAD_END = "loadend";
    public static final String TYPE_PROGRESS = "progress";
    public static final String TYPE_ABORT = "abort";
    public static final String TYPE_TIMEOUT = "timeout";
    public static final String TYPE_SCROLL = "scroll";
    public static final String TYPE_SEARCH = "search";
    public static final String TYPE_DRAGEND = "dragend";
    public static final String TYPE_INVALID = "invalid";
    public static final String TYPE_POINTEROUT = "pointerout";
    public static final String TYPE_HELP = "help";
    public static final String TYPE_RATECHANGE = "ratechange";
    public static final String TYPE_ANIMATIONITERATION = "animationiteration";
    public static final String TYPE_CANPLAYTHROUGH = "canplaythrough";
    public static final String TYPE_CANCEL = "cancel";
    public static final String TYPE_POINTERENTER = "pointerenter";
    public static final String TYPE_SELECT = "select";
    public static final String TYPE_AUXCLICK = "auxclick";
    public static final String TYPE_MSPOINTERLEAVE = "mspointerleave";
    public static final String TYPE_WEBANIMATIONSTART = "webkitanimationstart";
    public static final String TYPE_MSGESTURESTART = "msgesturestart";
    public static final String TYPE_DEVICEPROXIMITY = "deviceproximity";
    public static final String TYPE_DRAG = "drag";
    public static final String TYPE_SEEKED = "seeked";
    public static final String TYPE_OFFLINE = "offline";
    public static final String TYPE_DEVICEORIENTATION = "deviceorientation";
    public static final String TYPE_TOGGLE = "toggle";
    public static final String TYPE_PLAY = "play";
    public static final String TYPE_MSPOINTEROVER = "mspointerover";
    public static final String TYPE_MSPOINTERUP = "mspointerup";
    public static final String TYPE_LOADEDMETADATA = "loadedmetadata";
    public static final String TYPE_MSINERTIASTART = "msinertiastart";
    public static final String TYPE_POINTERMOVE = "pointermove";
    public static final String TYPE_MSPOINTERMOVE = "mspointermove";
    public static final String TYPE_USERPROXIMITY = "userproximity";
    public static final String TYPE_LOSTPOINTERCAPTURE = "lostpointercapture";
    public static final String TYPE_POINTEROVER = "pointerover";
    public static final String TYPE_ANIMATIONCANCEL = "animationcancel";
    public static final String TYPE_ANIMATIONEND = "animationend";
    public static final String TYPE_DRAGENTER = "dragenter";
    public static final String TYPE_AFTERPRINT = "afterprint";
    public static final String TYPE_MOZFULLSCREENERROR = "mozfullscreenerror";
    public static final String TYPE_MOUSELEAVE = "mouseleave";
    public static final String TYPE_MOUSEWHEEL = "mousewheel";
    public static final String TYPE_SEEKING = "seeking";
    public static final String TYPE_CUECHANGE = "cuechange";
    public static final String TYPE_PAGESHOW = "pageshow";
    public static final String TYPE_MSPOINTENTER = "mspointerenter";
    public static final String TYPE_MOZFULLSCREENCHANGE = "mozfullscreenchange";
    public static final String TYPE_DURATIONCHANGE = "durationchange";
    public static final String TYPE_PLAYNG = "playing";
    public static final String TYPE_ENDED = "ended";
    public static final String TYPE_LOADEDDATA = "loadeddata";
    public static final String TYPE_UNHANDLEDREJECTION = "unhandledrejection";
    public static final String TYPE_SUSPEND = "suspend";
    public static final String TYPE_WAITING = "waiting";
    public static final String TYPE_CANPLAY = "canplay";
    public static final String TYPE_LANGUAGECHANGE = "languagechange";
    public static final String TYPE_EMPTIED = "emptied";
    public static final String TYPE_REJECTIONHANDLED = "rejectionhandled";
    public static final String TYPE_POINTERCANCEL = "pointercancel";
    public static final String TYPE_MSGESTUREEND = "msgestureend";
    public static final String TYPE_RESIZE = "resize";
    public static final String TYPE_PAUSE = "pause";
    public static final String TYPE_POINTERUP = "pointerup";
    public static final String TYPE_WHEEL = "wheel";
    public static final String TYPE_MSPOINTERDOWN = "mspointerdown";
    public static final String TYPE_POINTERLEAVE = "pointerleave";
    public static final String TYPE_BEFOREPRINT = "beforeprint";
    public static final String TYPE_STORAGE = "storage";
    public static final String TYPE_DEVICELIGHT = "devicelight";
    public static final String TYPE_ANIMATIONSTART = "animationstart";
    public static final String TYPE_MSPOINTERCANCEL = "mspointercancel";
    public static final String TYPE_TIMEUPDATE = "timeupdate";
    public static final String TYPE_PAGEHIDE = "pagehide";
    public static final String TYPE_WEBKITANIMATIONITERATION = "webkitanimationiteration";
    public static final String TYPE_MSGESTURETAP = "msgesturetap";
    public static final String TYPE_DRAGOVER = "dragover";
    public static final String TYPE_ONLINE = "online";
    public static final String TYPE_MSGESTUREDOUBLETAP = "msgesturedoubletap";
    public static final String TYPE_SHOW = "show";
    public static final String TYPE_VOLUMECHANGE = "volumechange";
    public static final String TYPE_MSGESTURECHANGE = "msgesturechange";
    public static final String TYPE_GOTPOINTERCAPTURE = "gotpointercapture";
    public static final String TYPE_WEBKITTRANSITIONEND = "webkittransitionend";
    public static final String TYPE_WEBKITANIMATIONEND = "webkitanimationend";
    public static final String TYPE_MSPOINTEROUT = "mspointerout";
    public static final String TYPE_DEVICEMOTION = "devicemotion";
    public static final String TYPE_STALLED = "stalled";
    public static final String TYPE_MOUDEENTER = "mouseenter";
    public static final String TYPE_DRAGLEAVE = "dragleave";
    public static final String TYPE_POINTERDOWN = "pointerdown";
    public static final String TYPE_DROP = "drop";
    public static final String TYPE_DRAGSTART = "dragstart";
    public static final String TYPE_TRANSITIONEND = "transitionend";
    public static final String TYPE_MSGESTUREHOLD = "msgesturehold";
    public static final String TYPE_DEVICEORIENTATIONABSOLUTE = "deviceorientationabsolute";
    public static final String TYPE_BEFORECOPY = "beforecopy";
    public static final String TYPE_BEFORECUT = "beforecut";
    public static final String TYPE_BEFOREPASTE = "beforepaste";
    public static final String TYPE_SELECTSTART = "selectstart";
    public static final String TYPE_WEBKITFULLSCREENCHANGE = "webkitfullscreenchange";
    public static final String TYPE_WEBKITFULLSCREENERROR = "webkitfullscreenerror";
    public static final String TYPE_COPY = "copy";
    public static final String TYPE_CUT = "cut";
    public static final String TYPE_PASTE = "paste";
    public static final String TYPE_ONMESSAGEERROR = "onmessageerror";
    public static final String TYPE_STOP = "stop";
    public static final String TYPE_MSGOTPOINTERCAPTURE = "msgotpointercapture";
    public static final String TYPE_MSLOSTPOINTERCAPTURE = "mslostpointercapture";
    public static final String TYPE_ACTIVATE = "activate";
    public static final String TYPE_DEACTIVATE = "deactivate";
    public static final String TYPE_MSCONTENTZOOM = "mscontentzoom";
    public static final String TYPE_MSMANIPULATIONSTATECHANGED = "msmanipulationstatechanged";
    public static final String TYPE_BEFOREACTIVATE = "beforeactivate";
    public static final String TYPE_POINTERLOCKCHANGE = "pointerlockchange";
    public static final String TYPE_POINTERLOCKERROR = "pointerlockerror";
    public static final String TYPE_SELECTIONCHANGE = "selectionchange";
    public static final String TYPE_AFTERSCRIPTEXECUTE = "afterscriptexecute";
    public static final String TYPE_BEFORESCRIPTEXECUTE = "beforescriptexecute";
    public static final String TYPE_MSFULLSCREENCHANGE = "msfullscreenchange";
    public static final String TYPE_MSFULLSCREENERROR = "msfullscreenerror";
    public static final String TYPE_BEFOREDEACTIVATE = "beforedeactivate";
    public static final String TYPE_MSTHUMBNAILCLICK = "msthumbnailclick";
    public static final String TYPE_STORAGECOMMIT = "storagecommit";
    public static final String TYPE_ONTRANSITIONCANCEL = "ontransitioncancel";
    public static final String TYPE_ONTRANSITIONEND = "ontransitionend";
    public static final String TYPE_ONTRANSITIONRUN = "ontransitionrun";
    public static final String TYPE_ONTRANSITIONSTART = "ontransitionstart";
    public static final String TYPE_GAMEPAD_CONNECTED = "ongamepadconnected";
    public static final String TYPE_GAMEPAD_DISCONNECTED = "ongamepaddisconnected";
    public static final String TYPE_MSSITEMODEJUMPLISTITEMREMOVED = "mssitemodejumplistitemremoved";
    @JsxConstant(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final short NONE = 0;
    @JsxConstant
    public static final short CAPTURING_PHASE = 1;
    @JsxConstant
    public static final short AT_TARGET = 2;
    @JsxConstant
    public static final short BUBBLING_PHASE = 3;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final int ALT_MASK = 1;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final int CONTROL_MASK = 2;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final int SHIFT_MASK = 4;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static final int META_MASK = 8;
    private Object srcElement_;
    private EventTarget target_;
    private Scriptable currentTarget_;
    private String type_ = "";
    private int keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private boolean stopImmediatePropagation_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private final long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        this((EventTarget)domNode.getScriptableObject(), type);
        this.setDomNode(domNode, false);
    }

    public Event(EventTarget target, String type) {
        this.srcElement_ = target;
        this.target_ = target;
        this.currentTarget_ = target;
        this.type_ = type;
        this.setParentScope((Scriptable)target);
        this.setPrototype(this.getPrototype(this.getClass()));
        if (TYPE_CHANGE.equals(type)) {
            this.cancelable_ = false;
        } else if (TYPE_LOAD.equals(type)) {
            this.bubbles_ = false;
            this.cancelable_ = false;
        } else if (TYPE_ERROR.equals(type)) {
            this.bubbles_ = false;
        } else if (TYPE_FOCUS.equals(type) || TYPE_BLUR.equals(type)) {
            this.bubbles_ = false;
            this.cancelable_ = false;
        }
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    public void eventCreated() {
        this.setBubbles(false);
        this.setCancelable(false);
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(String type, ScriptableObject details) {
        boolean bubbles = false;
        boolean cancelable = false;
        if (details != null && !Undefined.isUndefined((Object)details)) {
            bubbles = ScriptRuntime.toBoolean((Object)details.get((Object)"bubbles"));
            cancelable = ScriptRuntime.toBoolean((Object)details.get((Object)"cancelable"));
        }
        this.initEvent(type, bubbles, cancelable);
    }

    public void startFire() {
        Context context = Context.getCurrentContext();
        ArrayList<Event> events = (ArrayList<Event>)context.getThreadLocal((Object)KEY_CURRENT_EVENT);
        if (events == null) {
            events = new ArrayList<Event>();
            context.putThreadLocal((Object)KEY_CURRENT_EVENT, events);
        }
        events.add(this);
    }

    public void endFire() {
        Context context = Context.getCurrentContext();
        ArrayList events = (ArrayList)context.getThreadLocal((Object)KEY_CURRENT_EVENT);
        if (events != null && events.size() > 0) {
            events.remove(events.size() - 1);
        }
    }

    @JsxGetter
    public Object getSrcElement() {
        return this.srcElement_;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setSrcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    @JsxGetter
    public Object getTarget() {
        return this.target_;
    }

    public void setTarget(EventTarget target) {
        this.target_ = target;
    }

    @JsxGetter
    public Scriptable getCurrentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    @JsxGetter
    public String getType() {
        return this.type_;
    }

    @JsxSetter
    public void setType(String type) {
        this.type_ = type;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    @JsxGetter
    public long getTimeStamp() {
        return this.timeStamp_;
    }

    protected void setKeyCode(int keyCode) {
        this.keyCode_ = keyCode;
    }

    public int getKeyCode() {
        return this.keyCode_;
    }

    public boolean isShiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    public boolean isCtrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    public boolean isAltKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    @JsxGetter
    public int getEventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    @JsxGetter
    public boolean isBubbles() {
        return this.bubbles_;
    }

    protected void setBubbles(boolean bubbles) {
        this.bubbles_ = bubbles;
    }

    @JsxGetter
    public boolean isCancelable() {
        return this.cancelable_;
    }

    protected void setCancelable(boolean cancelable) {
        this.cancelable_ = cancelable;
    }

    @JsxGetter
    public boolean isDefaultPrevented() {
        return this.cancelable_ && this.preventDefault_;
    }

    @JsxGetter
    public boolean isCancelBubble() {
        return this.stopPropagation_;
    }

    @JsxSetter
    public void setCancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    @JsxFunction
    public void stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    @JsxFunction
    public void stopImmediatePropagation() {
        this.stopImmediatePropagation_ = true;
        this.stopPropagation();
    }

    public boolean isImmediatePropagationStopped() {
        return this.stopImmediatePropagation_;
    }

    void handlePropertyHandlerReturnValue(Object returnValue) {
        if (Boolean.FALSE.equals(returnValue)) {
            this.preventDefault();
        }
    }

    public String getPropertyName() {
        return this.propertyName_;
    }

    @JsxFunction
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
    }

    @JsxFunction
    public void preventDefault() {
        if (this.isCancelable()) {
            this.preventDefault_ = true;
        }
    }

    public boolean isAborted(ScriptResult result) {
        return ScriptResult.isFalse(result) || this.preventDefault_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(40);
        builder.append("Event ").append(this.getType()).append(" (").append("Current Target: ").append(this.currentTarget_).append(");");
        return builder.toString();
    }

    public boolean processLabelAfterBubbling() {
        return false;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getReturnValue() {
        return !this.preventDefault_;
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setReturnValue(Object newValue) {
        if (this.isCancelable()) {
            boolean bool;
            boolean bl = bool = !ScriptRuntime.toBoolean((Object)newValue);
            if (bool) {
                this.preventDefault_ = bool;
            }
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getComposed() {
        return false;
    }

    protected static boolean isMissingOrUndefined(Object value) {
        return value == Scriptable.NOT_FOUND || Undefined.isUndefined((Object)value);
    }
}

