/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.Iterator;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClass=DomDocumentFragment.class)
public class DocumentFragment
extends Node {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DocumentFragment() {
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getChildElementCount() {
        int counter = 0;
        for (DomNode domNode : this.getDomNodeOrDie().getChildren()) {
            ++counter;
        }
        return counter;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getFirstElementChild() {
        Iterator<DomNode> iterator = this.getDomNodeOrDie().getChildren().iterator();
        if (iterator.hasNext()) {
            DomNode child = iterator.next();
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getLastElementChild() {
        DomNode lastChild = null;
        Iterator<DomNode> iterator = this.getDomNodeOrDie().getChildren().iterator();
        while (iterator.hasNext()) {
            DomNode child;
            lastChild = child = iterator.next();
        }
        if (lastChild != null) {
            return (Element)lastChild.getScriptableObject();
        }
        return null;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getElementById(Object id) {
        if (id == null || Undefined.isUndefined((Object)id)) {
            return null;
        }
        String idString = ScriptRuntime.toString((Object)id);
        if (idString == null || idString.length() == 0) {
            return null;
        }
        for (DomNode child : this.getDomNodeOrDie().getChildren()) {
            Element elem = (Element)child.getScriptableObject();
            if (!idString.equals(elem.getId())) continue;
            return elem;
        }
        return null;
    }
}

