/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.AppletConfirmHandler;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParameter;
import com.gargoylesoftware.htmlunit.html.applets.AppletClassLoader;
import com.gargoylesoftware.htmlunit.html.applets.AppletStubImpl;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.applet.Applet;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NodeList;

public class HtmlApplet
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlApplet.class);
    private static final String ARCHIVE = "archive";
    private static final String CACHE_ARCHIVE = "cache_archive";
    private static final String CODEBASE = "codebase";
    public static final String TAG_NAME = "applet";
    private Applet applet_;
    private List<URL> archiveUrls_;

    HtmlApplet(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getCodebaseAttribute() {
        return this.getAttribute(CODEBASE);
    }

    public final String getArchiveAttribute() {
        return this.getAttribute(ARCHIVE);
    }

    public final String getCodeAttribute() {
        return this.getAttributeDirect("code");
    }

    public final String getObjectAttribute() {
        return this.getAttributeDirect("object");
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getHeightAttribute() {
        return this.getAttributeDirect("height");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeDirect("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeDirect("vspace");
    }

    public Applet getApplet() throws IOException {
        this.setupAppletIfNeeded();
        return this.applet_;
    }

    private synchronized void setupAppletIfNeeded() throws IOException {
        HtmlPage page;
        WebClient webclient;
        AppletConfirmHandler handler;
        if (this.applet_ != null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.getNameAttribute());
        params.put("object", this.getObjectAttribute());
        params.put("align", this.getAlignAttribute());
        params.put("alt", this.getAltAttribute());
        params.put("height", this.getHeightAttribute());
        params.put("hspace", this.getHspaceAttribute());
        params.put("vspace", this.getVspaceAttribute());
        params.put("width", this.getWidthAttribute());
        NodeList paramTags = this.getElementsByTagName("param");
        Iterator iterator = paramTags.iterator();
        while (iterator.hasNext()) {
            HtmlElement paramTag = (HtmlElement)iterator.next();
            HtmlParameter parameter = (HtmlParameter)paramTag;
            params.put(parameter.getNameAttribute(), parameter.getValueAttribute());
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)params.get(CODEBASE))) && StringUtils.isNotEmpty((CharSequence)this.getCodebaseAttribute())) {
            params.put(CODEBASE, this.getCodebaseAttribute());
        }
        String codebaseProperty = (String)params.get(CODEBASE);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)params.get(ARCHIVE))) && StringUtils.isNotEmpty((CharSequence)this.getArchiveAttribute())) {
            params.put(ARCHIVE, this.getArchiveAttribute());
        }
        if (null != (handler = (webclient = (page = (HtmlPage)this.getPage()).getWebClient()).getAppletConfirmHandler()) && !handler.confirm(this)) {
            return;
        }
        String appletClassName = this.getCodeAttribute();
        if (appletClassName.endsWith(".class")) {
            appletClassName = appletClassName.substring(0, appletClassName.length() - 6);
        }
        try (AppletClassLoader appletClassLoader = new AppletClassLoader((Window)this.getPage().getEnclosingWindow().getScriptableObject(), Thread.currentThread().getContextClassLoader());){
            URL archiveUrl;
            String tempUrl;
            String documentUrl = page.getUrl().toExternalForm();
            String baseUrl = UrlUtils.resolveUrl(documentUrl, ".");
            if (StringUtils.isNotEmpty((CharSequence)codebaseProperty)) {
                baseUrl = UrlUtils.resolveUrl(baseUrl, codebaseProperty);
            }
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            ArrayList<URL> archiveUrls = new ArrayList<URL>();
            String[] archives = StringUtils.split((String)((String)params.get(ARCHIVE)), (char)',');
            if (null != archives) {
                for (String tmpArchive : archives) {
                    tempUrl = UrlUtils.resolveUrl(baseUrl, tmpArchive.trim());
                    archiveUrl = UrlUtils.toUrlUnsafe(tempUrl);
                    appletClassLoader.addArchiveToClassPath(archiveUrl);
                    archiveUrls.add(archiveUrl);
                }
            }
            if (null != (archives = StringUtils.split((String)((String)params.get(CACHE_ARCHIVE)), (char)','))) {
                for (String tmpArchive : archives) {
                    tempUrl = UrlUtils.resolveUrl(baseUrl, tmpArchive.trim());
                    archiveUrl = UrlUtils.toUrlUnsafe(tempUrl);
                    appletClassLoader.addArchiveToClassPath(archiveUrl);
                    archiveUrls.add(archiveUrl);
                }
            }
            this.archiveUrls_ = Collections.unmodifiableList(archiveUrls);
            if (this.archiveUrls_.isEmpty()) {
                String tempUrl2 = UrlUtils.resolveUrl(baseUrl, this.getCodeAttribute());
                URL classUrl = UrlUtils.toUrlUnsafe(tempUrl2);
                WebResponse response = webclient.loadWebResponse(new WebRequest(classUrl));
                try {
                    webclient.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                    appletClassLoader.addClassToClassPath(appletClassName, response);
                }
                catch (FailingHttpStatusCodeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                Class<?> appletClass = appletClassLoader.loadClass(appletClassName);
                this.applet_ = (Applet)appletClass.newInstance();
                this.applet_.setStub(new AppletStubImpl(this.getHtmlPageOrNull(), params, UrlUtils.toUrlUnsafe(baseUrl), UrlUtils.toUrlUnsafe(documentUrl)));
                this.applet_.init();
                this.applet_.start();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Loading applet '" + appletClassName + "' failed\n    " + e + "\n    Classpath:\n" + appletClassLoader.info()));
                }
                throw new RuntimeException(e);
            }
        }
    }

    public List<URL> getArchiveUrls() {
        return this.archiveUrls_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

