/*
 * Copyright (c) 2008-2010 Ronald Brill
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.rbri.wet.ide.swing.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.AbstractBorder;

/**
 * @author rbri
 */
public class TopLeftRaisedBorder extends AbstractBorder {

  private static final long serialVersionUID = -2603817619868418848L;

  private static final Insets INSETS = new Insets(1, 1, 1, 0);

  @Override
  public Insets getBorderInsets(Component aComponent) {
    return INSETS;
  }

  @Override
  public void paintBorder(Component aComponent, Graphics aGraphics, int anX, int aY, int aWidth, int aHeight) {
    aGraphics.translate(anX, aY);

    aGraphics.setColor(LookAndFeelUtil.getControlLtHighlightColor());
    aGraphics.fillRect(0, 0, aWidth, 1);
    aGraphics.fillRect(0, 1, 1, aHeight - 1);

    aGraphics.setColor(LookAndFeelUtil.getControlShadowColor());
    aGraphics.fillRect(0, aHeight - 1, aWidth, 1);

    aGraphics.translate(-anX, -aY);
  }

}
